<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
//$routes->get('/', 'Home::index');

//Frontend Routes
$routes->add('/', 'Home::index');
$routes->add('/about-us', 'Home::about_us');
$routes->add('/terms-and-conditions', 'Home::terms');
$routes->add('/privacy-policy', 'Home::privacy');
$routes->add('/login', 'Users::login');
$routes->add('/logout', 'Users::logout');
$routes->add('/register', 'Users::register');
$routes->add('/my-account', 'Users::index');
$routes->add('/manageShoppingCart', 'Home::manageShoppingCart');
$routes->add('/labs', 'Labs::index');
$routes->add('/labs/(:any)/(:any)', 'Labs::page/$1/$2');
$routes->add('/tests', 'Tests::index');
$routes->add('/tests/(:any)/(:any)', 'Tests::page/$1/$2');
$routes->add('/cart', 'Cart::index');

//Admin Routes
$routes->group('admin', function ($routes) {
    $routes->add('/', 'Admin\Dashboard');
    $routes->add('login', 'Admin\Login');
    $routes->add('logout', 'Admin\Login::logout');
});

//$routes->get('api/service-categories', 'ServiceCategory::index');
//API
$routes->group('api', ['namespace' => 'App\Controllers\API', 'middleware' => 'JsonRequestMiddleware'], function ($routes) {
    $routes->resource('register', ['only' => ['index', 'post']]);
    $routes->post('register', 'Register::index');
    $routes->post('login', 'Login::index');
    $routes->post('prescription', 'Prescription::upload');
    $routes->get('prescription/list/(:num)', 'Prescription::listPrescription/$1');
    $routes->post('prescription/delete', 'Prescription::deletePrescription');
    $routes->resource('users');
    $routes->get('service-categories', 'ServiceCategory::index');
});
