<?php

namespace App\Controllers\API;

use CodeIgniter\RESTful\ResourceController;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;

class Login extends ResourceController
{
    protected $modelName = 'App\Models\Customers_model';
    protected $format = 'json';

    public function index()
    {
        $json_data = $this->request->getBody();
        $data = json_decode($json_data, true);
        $contentType = $this->request->getHeaderLine('Content-Type');

        if ($contentType != 'application/json' || json_decode($json_data) === null) {
            return $this->respond([
                'status' => 'error',
                'message' => 'Invalid Request'
            ], 400);
        }

        $requiredKeys = ['phone', 'requestFrom', 'token', 'ip'];

        if (!validate_fields($data, $requiredKeys)) {
            return $this->respond([
                'status' => 'error',
                'message' => 'Invalid Request, some keys are missing'
            ], 400);
        }

        $phone = $data["phone"];
        $otp = isset($data["otp"]) ? $data["otp"] : null;
        $userid = isset($data["userid"]) ? $data["userid"] : null;

        if (isset($phone) && $phone != "") {
            if (!validate_phone_number($phone)) {
                return $this->respond([
                    'status' => 'error',
                    'message' => 'Invalid Phone Number'
                ], 400);
            }

            $message = '';
            $status = "error";

            if ($otp == '') {
                $result = $this->model->where(['mobile' => $phone, 'status' => 1])->first();

                if (is_array($result)) {
                    $otp = mt_rand(10000, 99999);
                    $otp = '1234';
                    $this->model->update($result['id'], [
                        'otp' => $otp
                    ]);
                    $userid = $result['id'];
                    $message = 'Otp sent to your mobile no.';
                    $status = "success";
                } else {
                    $message = 'No user found with this number or account inactive try Sign up';
                    return $this->respond([
                        'status' => $status,
                        'message' => $message
                    ], 200);
                }

                return $this->respond([
                    'status' => $status,
                    'message' => $message,
                    'data' => ['userid' => $userid]
                ], 200);
            } else {
                $result = $this->model->select('id as userid, name, email, age, gender, profile_img')
                    ->where(['id' => $userid, 'otp' => $otp, 'status' => 1])
                    ->first();

                if (is_array($result)) {
                    $this->model->update($result['userid'], [
                        'otp' => ''
                    ]);
                    $message = 'User logged in Successfully';
                    $status = "success";
                } else {
                    $message = 'Please check the otp you entered.';
                    $status = "error";
                }

                return $this->respond([
                    'status' => $status,
                    'message' => $message,
                    'data' => $result
                ], 200);
            }
        } else {
            return $this->respond([
                'status' => 'error',
                'message' => 'Invalid Request'
            ], 400);
        }
    }
}