<?php 
namespace App\Controllers\API;

use CodeIgniter\RESTful\ResourceController;

class Register extends ResourceController
{
    protected $modelName = 'App\Models\Customers_model';
    protected $format = 'json';

    public function index()
    {
        $json_data = $this->request->getBody();
        $data = json_decode($json_data, true);

        if (!$this->isValidRequest($json_data)) {
            return $this->respond([
                'status' => 'error',
                'message' => 'Invalid Request'
            ], 400);
        }

        $requiredKeys = ['phone', 'name', 'requestFrom', 'token', 'ip'];

        if (!$this->hasRequiredKeys($data, $requiredKeys)) {
            return $this->respond([
                'status' => 'error',
                'message' => 'Invalid Request, some keys are missing'
            ], 400);
        }

        $otp = $data["otp"] ?? null;
        $name = $data["name"];
        $phonenumber = $data["phone"];
        $userid = $data["userid"] ?? null;

        if (!$this->isValidPhoneNumber($phonenumber)) {
            return $this->respond([
                'status' => 'error',
                'message' => 'Invalid Phone Number'
            ], 400);
        }

        if ($otp == '') {
            return $this->sendOtp($name, $phonenumber);
        } else {
            return $this->verifyOtp($userid, $otp);
        }
    }

    private function isValidRequest($data)
    {
        $contentType = $this->request->getHeaderLine('Content-Type');
        return $contentType == 'application/json' && json_decode($data) !== null;
    }

    private function hasRequiredKeys($data, $requiredKeys)
    {
        foreach ($requiredKeys as $key) {
            if (!array_key_exists($key, $data)) {
                return false;
            }
        }
        return true;
    }

    private function isValidPhoneNumber($phonenumber)
    {
        return validate_phone_number($phonenumber);
    }

    private function sendOtp($name, $phonenumber)
    {
        $otp = mt_rand(100000, 999999);
        $otp = '1234';
        $status ="error";
        if ($this->model->where('mobile', $phonenumber)->countAllResults() > 0) {
            $query = $this->model->where(['mobile' => $phonenumber])->first();

            if ($query['status'] == '0') {
                $this->model->update($query['id'], [
                    'name' => $name,
                    'otp' => $otp
                ]);

                $userid = $query['id'];
                $message = 'Otp sent to your mobile no.';
                $status = "success";
            } else {
                $message = 'This number already registered, please try login.';
                $userid = '';
            }
        } else {
            $this->model->save([
                'name' => $name,
                'mobile' => $phonenumber,
                'otp' => $otp,
                'status' => 0,
            ]);

            $userid = $this->model->insertID();
            $message = 'Otp sent to your mobile no.';
            $status = "success";
        }

        return $this->respond([
            'status' => $status,
            'message' => $message,
            'data' => ['userid' => $userid]
        ], 200);
    }

    private function verifyOtp($userid, $otp)
    {
        if ($this->model->asArray()->where(['id' => $userid, 'otp' => $otp])->countAllResults() > 0) {
            $this->model->update($userid, [
                'status' => "1",
                'otp' => ''
            ]);

            $message = 'User registered, Please login';
            $status = "success";
        } else {
            $message = 'OTP did not match, please try again.';
            $status = "error";
        }

        return $this->respond([
            'status' => $status,
            'message' => $message
        ], 200);
    }
}
?>