<?php

namespace App\Controllers\API;

use CodeIgniter\RESTful\ResourceController;
use App\Models\ServiceCategoryModel;

class ServiceCategory extends ResourceController
{
    protected $format = 'json';

    public function index()
    {
        $model = new ServiceCategoryModel();

        $categories = $model
            ->select('name, slug, id')
            ->where('status', 1)
            ->orderBy('display_order', 'ASC')
            ->orderBy('name', 'ASC')
            ->findAll();

        return $this->respond([
            'status' => 'success',
            'data' => $categories
        ]);
    }
}
