<?php namespace App\Controllers\Admin;

use App\Controllers\AdminBase;
use App\Models\Adminmodel;

class Admin_users extends AdminBase
{
	protected $model;
	
	public function __construct()
	{
		if(empty(session()->get('is_admin'))) {
			header('Location: '.base_url('admin/login'));
			exit;	
		}
		if(session()->get('role')==2) {
			header('Location: '.base_url('admin/'));
			exit;	
		}
		$this->model = new Adminmodel();
		
	}
	
	public function index()
	{
		$data['title'] = 'Admin Users';
		$data['list'] = $this->model->findAll();
		if ($this->request->getMethod() == 'post') {
			$this->model->update($this->request->getPost('id'), array(
				'name' => $this->request->getPost('name'),
				'state_id' => $this->request->getPost('state'),
				'city_id' => $this->request->getPost('city'),
				'address' => $this->request->getPost('address'),
				'latitude' => $this->request->getPost('lat'),
				'longitude' => $this->request->getPost('long'),
				'description' => $this->request->getPost('description'),
				'image' => $img
			));
			session()->setFlashdata('success', 'Admin user updated successfully.');
			return redirect()->to(base_url('admin/admin-users/'));
		}
		echo view('admin/users/list', $data);
	}
		
	public function add()
	{ 
		$data['title'] = 'Add Admin Users';
		if ($this->request->getMethod() == 'post') {
			$this->model->insert([
				'username' => $this->request->getPost('username'),
				'password' => password_hash($this->request->getPost('password'), PASSWORD_DEFAULT),
				'role' => $this->request->getPost('role'),
				'last_login' => date('Y-m-d H:i:s'),
				'registered_date' => date('Y-m-d H:i:s')
			]);
			session()->setFlashdata('success', 'New User added successfully.');
			return redirect()->to(base_url('admin/admin-users/add'));
		}
		echo view('admin/users/add', $data);
	}
	
	public function changePassword() {
	    if ($this->request->getMethod() == 'post') {
			$this->model->update($this->request->getPost('id'), array(
				'password' => password_hash($this->request->getPost('password'), PASSWORD_DEFAULT),
			));
			session()->setFlashdata('success', 'Password changed successfully.');
			return redirect()->to(base_url('admin/admin-users/'));
		}
	}
	
	public function remove($id) {
		if($id!='') {
			$this->model->delete($id);	
			session()->setFlashdata('success', 'Selected admin user removed successfully.');
			return redirect()->to(base_url('admin/admin-users/'));
		} else {
			throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
		}
	}

}
