<?php namespace App\Controllers\Admin;

use App\Controllers\AdminBase;
use App\Models\Bookings_model;

class Bookings extends AdminBase
{
	protected $model;
	
	public function __construct()
	{
		if(empty(session()->get('is_admin'))) {
			header('Location: '.base_url('admin/login'));
			exit;	
		}
		$this->model = new Bookings_model();
	}
	
	public function index()
	{
	    if($this->request->getGet('changeto') && $this->request->getGet('changeto')!='') {
	        $this->model->update($this->request->getGet('bid'), ['status' =>$this->request->getGet('changeto')]);
	        session()->setFlashdata('success', 'Status changed successfully.');
			return redirect()->to(base_url('admin/bookings/'));
	    }
		$data['title'] = 'All Bookings / Orders';
		$data['list'] = $this->model->findAll();
		echo view('admin/bookings/list', $data);
	}

}
