<?php

namespace App\Controllers\Admin;

use App\Controllers\AdminBase;
use App\Models\Collectors_model;

class Collectors extends AdminBase
{
	protected $model;

	public function __construct()
	{
		if (!session()->get('is_admin') == 1) {
			header('Location: ' . base_url() . '/admin/login');
			exit;
		}
		if(session()->get('role')==2) {
			header('Location: '.base_url('admin/'));
			exit;	
		}
		$this->model = new Collectors_model();
	}

	public function index()
	{
		$data['title'] = 'Collectors';
		$data['list'] = $this->model->findAll();
		if ($this->request->getMethod() == 'post') {
			$id = $this->request->getPost('id');
			$this->model->update($id, array(
				'name' => $this->request->getPost('username'),
				'email' => $this->request->getPost('email'),
				'mobile' => $this->request->getPost('mobile'),
				'status' => $this->request->getPost('status')
			));
			session()->setFlashdata('success', 'Collector details updated successfully.');
			return redirect()->to(base_url('admin/collectors/'));
		}
		echo view('admin/collectors/list', $data);
	}

	public function add()
	{
		$data['title'] = 'Add Collectors';
		if ($this->request->getMethod() == 'post') {
			$this->model->insert(array(
				'name' => $this->request->getPost('username'),
				'email' => $this->request->getPost('email'),
				'mobile' => $this->request->getPost('mobile'),
				'status' => 'active',
				'joining_date' => date('Y-m-d')
			));
			session()->setFlashdata('success', 'New collector added successfully.');
			return redirect()->to(base_url('admin/collectors/add'));
		}
		echo view('admin/collectors/add', $data);
	}

	public function remove($id)
	{
		if ($id != '') {
			$this->model->delete($id);
			session()->setFlashdata('success', 'Selected collector removed successfully.');
			return redirect()->to(base_url('admin/collectors/'));
		} else {
			throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound('Not Allowed');
		}
	}
}