<?php namespace App\Controllers\Admin;

use App\Controllers\AdminBase;
use App\Models\Customers_model;

class Customers extends AdminBase
{
	protected $model;

	public function __construct()
	{
		if(!session()->get('is_admin') == 1) {
			header('Location: '.base_url().'/admin/login');	
			exit;
		}
		if(session()->get('role')==2) {
			header('Location: '.base_url('admin/'));
			exit;	
		}
		$this->model = new Customers_model();
	}
	
	public function index()
	{
		$data['title'] = 'Customers';
		$data['list'] = $this->model->findAll();
		if ($this->request->getMethod() == 'post') {
			$id = $this->request->getPost('id');
			$profile_img = $this->request->getPost('old_profileImg');
			$validated = $this->validate([
				'profile' => [
					'uploaded[profile]',
					'mime_in[profile,image/jpg,image/jpeg,image/gif,image/png]',
					'max_size[profile,4096]',
				],
			]);	  
			if($validated) {
				$profile = $this->request->getFile('profile');
				$profile->move('public/assets/images/profile/');
				$profile_img = $profile->getClientName();
			}			
			if($this->request->getPost('password') == '') {
				$this->model->update($id, array(
					'name' => $this->request->getPost('username'),
					'email' => $this->request->getPost('email'),
					'mobile' => $this->request->getPost('mobile'),
					'age' => $this->request->getPost('age'),
					'gender' => $this->request->getPost('gender'),
					'profile_img' => $profile_img,
					'status' => '1'
				));
			} else {
				$this->model->update($id, array(
					'name' => $this->request->getPost('username'),
					'password' => password_hash($this->request->getPost('password'), PASSWORD_DEFAULT),
					'email' => $this->request->getPost('email'),
					'mobile' => $this->request->getPost('mobile'),
					'age' => $this->request->getPost('age'),
					'gender' => $this->request->getPost('gender'),
					'profile_img' => $profile_img,
					'status' => '1'
				));
			}
			session()->setFlashdata('success', 'Customer details successfully.');
			return redirect()->to(base_url('admin/customers/'));
		}
		echo view('admin/customers/list', $data);
	}
		
	public function add()
	{ 
		$data['title'] = 'Add Customer';
		if ($this->request->getMethod() == 'post') {			
			$builder = $this->model->where('mobile', $this->request->getPost('mobile'))->first();
			if($builder['id'] == '' || $builder['mobile'] != $this->request->getPost('mobile')) {
				$profile_img = '';
				$validated = $this->validate([
					'profile' => [
						'uploaded[profile]',
						'mime_in[profile,image/jpg,image/jpeg,image/gif,image/png]',
						'max_size[profile,4096]',
					],
				]);	  
				if($validated) {
					$profile = $this->request->getFile('profile');
					$profile->move('public/assets/images/profile/');
					$profile_img = $profile->getClientName();
				}
				$this->model->insert(array(
					'name' => $this->request->getPost('username'),
					'password' => password_hash($this->request->getPost('password'), PASSWORD_DEFAULT),
					'email' => $this->request->getPost('email'),
					'mobile' => $this->request->getPost('mobile'),
					'age' => $this->request->getPost('age'),
					'gender' => $this->request->getPost('gender'),
					'profile_img' => $profile_img,
					'status' => '1',
					'registered_date' => date('Y-m-d H:i:s')
				));
				session()->setFlashdata('success', 'New customer added successfully.');
				return redirect()->to(base_url('admin/customers/add'));
			} else {
				session()->setFlashdata('error', 'Mobile Number already exist.');
				return redirect()->to(base_url('admin/customers/add'));	
			}
		}
		echo view('admin/customers/add', $data);
	}
	
	public function remove_img() 
	{
		if ($this->request->isAJAX()) { 
			$id = $this->request->getPost('id');
			$img = $this->request->getPost('img');
			$file = 'public/assets/images/profile/'.$img;
			$array = array('profile_img' => '');
			$this->model->update($id, $array);
			if(is_readable($file)) {	
				unlink($file);
			}
		} else {
			throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
		}
	}
	
	public function remove($id) {
		if($id!='') {
			$this->model->delete($id);	
			session()->setFlashdata('success', 'Selected customer removed successfully.');
			return redirect()->to(base_url('admin/customers/'));
		} else {
			throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
		}
	}

}