<?php namespace App\Controllers\Admin;

use App\Controllers\AdminBase;
use App\Models\Adminmodel ;

class Login extends AdminBase
{
	protected $model;

	public function __construct()
	{
		$this->model = new Adminmodel();		
	}
	public function index()
	{
		$data['title'] = '';		
		if(session()->get('is_admin') == 1) {
			return redirect()->to(base_url('admin'));	
		}
		if ($this->request->getMethod()=='post') {
			$rules = [
				'password' => 'required|min_length[2]|max_length[22]',
			];
			$errors = [
				'password' => [
					'validateUser' => 'username or Password don\'t match'
				]
			];
			if (!$this->validate($rules, $errors)) 
			{
				session()->setFlashdata('error', $this->validator->getErrors());
				return redirect()->to(base_url('admin/login'));				
			} else {
				$d = array('username'=>$this->request->getPost('username'), 'password'=>$this->request->getPost('password'));
				$check_user = $this->model->checkUser($d);				
				if(!empty($check_user)) 
				{
				    $this->model->update($check_user['id'], ['last_login' => date('Y-m-d H:i:s')]);
					session()->set(['admin_user' => $check_user['id'], 'is_admin' => 1, 'role' => $check_user['role'], 'last_login'=> $check_user['last_login']]);
					return redirect()->to(base_url('admin'));
				} else {
					session()->setFlashdata('error', 'Incorrect username or password');
					return redirect()->to(base_url('admin/login'))->withInput();
				}
			}
		}
		echo view('admin/login', $data);		
	}
	
	public function logout() {
		session()->remove(['admin_user', 'is_admin', 'role']);
		return redirect()->to(base_url('admin/login'));
	}

	//--------------------------------------------------------------------

}