<?php namespace App\Controllers\Admin;

use App\Controllers\AdminBase;
use App\Models\Offers_model;
use App\Models\Services_model;

class Offers extends AdminBase
{
	protected $model;
	protected $services;

	public function __construct()
	{
		if(!session()->get('is_admin') == 1) {
			redirect()->to(base_url('admin/login'));	
		}
		if(session()->get('role')==2) {
			header('Location: '.base_url('admin/'));
			exit;	
		}
		$this->model = new Offers_model();
		$services = new Services_model();
		$this->services = $services->findAll();
	}
	
	public function index()
	{
		$data['title'] = 'Offers';
		$data['list'] = $this->model->findAll();
		$data['services'] = $this->services;
		if ($this->request->getMethod() == 'post') {
			$offer_img = $this->request->getPost('old_offer_img');
			$id = $this->request->getPost('id');
			$validated = $this->validate([
				'offer_img' => [
					'uploaded[offer_img]',
					'mime_in[offer_img,image/jpg,image/jpeg,image/gif,image/png]',
					'max_size[offer_img,4096]',
				],
			]);	  
			if($validated) {
				$profile = $this->request->getFile('offer_img');
				$profile->move('public/assets/images/services/');
				$offer_img = $profile->getClientName();
			}
			$this->model->update($id, [
				'time_start' => $this->request->getPost('time_start'),
				'time_end' => $this->request->getPost('time_end'),
				'discount' => $this->request->getPost('discount'),
				'image' => $offer_img,
				'service_id' => ($this->request->getPost('discount_type')=='services') ? $this->request->getPost('service_id'): '',
				'type' => $this->request->getPost('discount_type'),
				'discount_code_type' => $this->request->getPost('discount_code_type'),
				'discount_code' => $this->request->getPost('promocode')
			]);
			session()->setFlashdata('success', 'Offer details updated successfully.');
			return redirect()->to(base_url('admin/offers/'));
		}
		echo view('admin/offers/list', $data);
	}
		 
	public function add()
	{ 
		$data['title'] = 'Add Offer';
		$data['services'] = $this->services;
		if ($this->request->getMethod() == 'post') {
			$offer_img = '';
			$validated = $this->validate([
				'offer_img' => [
					'uploaded[offer_img]',
					'mime_in[offer_img,image/jpg,image/jpeg,image/gif,image/png]',
					'max_size[offer_img,4096]',
				],
			]);	  
			if($validated) {
				$profile = $this->request->getFile('offer_img');
				$profile->move('public/assets/images/services/');
				$offer_img = $profile->getClientName();
			}
			$this->model->insert([
				'time_start' => $this->request->getPost('time_start'),
				'time_end' => $this->request->getPost('time_end'),
				'discount' => $this->request->getPost('discount'),
				'image' => $offer_img,
				'service_id' =>($this->request->getPost('discount_type')=='services') ? $this->request->getPost('service_id'): '',
				'type' => $this->request->getPost('discount_type'),
				'discount_code_type' => $this->request->getPost('discount_code_type'),
				'discount_code' => $this->request->getPost('promocode')
			]);
			session()->setFlashdata('success', 'New offer added successfully.');
			return redirect()->to(base_url('admin/offers/add'));
		}
		echo view('admin/offers/add', $data);
	}
	
	public function remove_img() 
	{
		if ($this->request->isAJAX()) { 
			$id = $this->request->getPost('id');
			$img = $this->request->getPost('img');
			$file = 'public/assets/images/services/'.$img;
			$array = array('image' => '');
			$this->model->update($id, $array);
			if(is_readable($file)) {	
				unlink($file);
			}
		} else {
			throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
		}
	}
	
	public function remove($id) {
		if($id!='') {
			$this->model->delete($id);	
			session()->setFlashdata('success', 'Selected offer removed successfully.');
			return redirect()->to(base_url('admin/offers/'));
		} else {
			throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
		}
	}

}
