<?php namespace App\Controllers\Admin;

use App\Controllers\AdminBase;
use App\Models\Pathologies_model;

class Pathologies extends AdminBase
{
	protected $model;
	
	public function __construct()
	{
		if(empty(session()->get('is_admin'))) {
			header('Location: '.base_url('admin/login'));
			exit;	
		}
		if(session()->get('role')==2) {
			header('Location: '.base_url('admin/'));
			exit;	
		}
		$this->model = new Pathologies_model();
	}
	
	public function index()
	{
		$data['title'] = 'Pathology Labs';
		$data['list'] = $this->model->findAll();
		$data['state'] = getResultAllFunc('master_state', '*');
		if ($this->request->getMethod() == 'post') {
			$img = $this->request->getPost('old_path_img');
			$validated = $this->validate([
				'path_image' => [
					'uploaded[path_image]',
					'mime_in[path_image,image/jpg,image/jpeg,image/gif,image/png]',
					'max_size[path_image,4096]',
				],
			]);	  
			if($validated) {
				$uploaded = $this->request->getFile('path_image');
				$uploaded->move('public/assets/images/');
				$img = $uploaded->getClientName();
			}
			$this->model->update($this->request->getPost('id'), array(
				'name' => $this->request->getPost('name'),
				'state_id' => $this->request->getPost('state'),
				'city_id' => $this->request->getPost('city'),
				'address' => $this->request->getPost('address'),
				'latitude' => $this->request->getPost('lat'),
				'longitude' => $this->request->getPost('long'),
				'description' => $this->request->getPost('description'),
				'image' => $img
			));
			session()->setFlashdata('success', 'Pathology Lab details updated successfully.');
			return redirect()->to(base_url('admin/pathologies/'));
		}
		echo view('admin/pathologies/list', $data);
	}
		
	public function add()
	{ 
		$data['title'] = 'Add Pathology Lab';
		$data['state'] = getResultAllFunc('master_state', '*');
		if ($this->request->getMethod() == 'post') {
			$img = '';
			$validated = $this->validate([
				'path_image' => [
					'uploaded[path_image]',
					'mime_in[path_image,image/jpg,image/jpeg,image/gif,image/png]',
					'max_size[path_image,4096]',
				],
			]);	  
			if($validated) {
				$uploaded = $this->request->getFile('path_image');
				$uploaded->move('public/assets/images/');
				$img = $uploaded->getClientName();
			}
			$this->model->insert(array(
				'name' => $this->request->getPost('name'),
				'state_id' => $this->request->getPost('state'),
				'city_id' => $this->request->getPost('city'),
				'address' => $this->request->getPost('address'),
				'latitude' => $this->request->getPost('lat'),
				'longitude' => $this->request->getPost('long'),
				'description' => $this->request->getPost('description'),
				'image' => $img
			));
			session()->setFlashdata('success', 'New Pathology Lab added successfully.');
			return redirect()->to(base_url('admin/pathologies/add'));
		}
		echo view('admin/pathologies/add', $data);
	}
	
	public function remove($id) {
		if($id!='') {
			$this->model->delete($id);	
			session()->setFlashdata('success', 'Selected Pathology Lab removed successfully.');
			return redirect()->to(base_url('admin/pathologies/'));
		} else {
			throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
		}
	}
	
	public function getCityAjax() {
		if ($this->request->isAJAX()) { 
			$state_id = $this->request->getPost('id');
			$where = ['state_id' => $state_id];
			$result = getResultAllFunc('master_city', 'id, name', $where);
			return $this->response->setJSON($result);
		die();
		} else {
			throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
		}
	}

	public function remove_img() 
	{
		if ($this->request->isAJAX()) { 
			$id = $this->request->getPost('id');
			$img = $this->request->getPost('img');
			$file = 'public/assets/images/'.$img;
			$array = array('image' => '');
			$this->model->update($id, $array);
			if(is_readable($file)) {	
				unlink($file);
			}
		} else {
			throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
		}
	}

}
