<?php namespace App\Controllers\Admin;

use App\Controllers\AdminBase;
use App\Models\Tests_model;
use App\Models\Pathologies_model;
use App\Models\Services_model;
use App\Models\Dump_model;

class Tests extends AdminBase
{
	protected $model;
	protected $services;
	protected $pathologies;
	protected $db;

	public function __construct()
	{
		if(!session()->get('is_admin') == 1) {
			header('Location: admin/login');
		}
		if(session()->get('role')==2) {
			header('Location: '.base_url('admin/'));
			exit;	
		}
		$this->model = new Tests_model();
		$services = new Services_model();		
		$this->services = $services->findAll();
		$pathologies = new Pathologies_model();
		$this->pathologies = $pathologies->findAll();
		$this->db      = \Config\Database::connect();
	}
	
	public function index()
	{
		$data['title'] = 'Tests';
		$data['list'] = $this->model->findAll();
		$data['services'] = $this->services;
		$data['pathos'] = $this->pathologies;
		if ($this->request->getMethod() == 'post') {
			$img = $this->request->getPost('old_test_img');
			$validated = $this->validate([
				'test_image' => [
					'uploaded[test_image]',
					'mime_in[test_image,image/jpg,image/jpeg,image/gif,image/png]',
					'max_size[test_image,4096]',
				],
			]);	  
			if($validated) {
				$uploaded = $this->request->getFile('test_image');
				$uploaded->move('public/assets/images/tests/');
				$img = $uploaded->getClientName();
			}
			$this->model->update($this->request->getPost('id'), [
				'name' => $this->request->getPost('name'),
				'test_code' => $this->request->getPost('test_code'),
				'base_price' => $this->request->getPost('base_price'),
				'service_id' => $this->request->getPost('service_id'),
				'is_active' => $this->request->getPost('is_active'),
				'description' => $this->request->getPost('description'),
				'image' => $img
			]);
			$patho_id = $this->request->getPost('patho_id');
			$mrp = $this->request->getPost('mrp');
			$orgprice = $this->request->getPost('orgprice');
			$medicooffer = $this->request->getPost('medicooffer');
			$builder = $this->db->table('tbl_testbypath');
			$builder->where('test_id', $this->request->getPost('id'));
			$builder->delete();
			if(!empty($patho_id)) {
				$i = 0;
				foreach ($patho_id as $key => $value) {
					$ins = [
						'test_id' => $this->request->getPost('id'),
						'patho_id' => $value,
						'mrp' => $mrp[$i],
						'orgprice' => $orgprice[$i],
						'medicooffer' => $medicooffer[$i]
					];					
					$builder->insert($ins);
					$i++;
				}
			}		
			session()->setFlashdata('success', 'Test details updated successfully.');
			return redirect()->to(base_url('admin/tests/'));
		}
		echo view('admin/tests/list', $data);
	}
		
	public function add()
	{ 
		$data['title'] = 'Add Test';
		$data['pathos'] = $this->pathologies;
		$data['services'] = $this->services;
		if ($this->request->getMethod() == 'post') {
			$img = '';
			$validated = $this->validate([
				'test_image' => [
					'uploaded[test_image]',
					'mime_in[test_image,image/jpg,image/jpeg,image/gif,image/png]',
					'max_size[test_image,4096]',
				],
			]);	  
			if($validated) {
				$uploaded = $this->request->getFile('test_image');
				$uploaded->move('public/assets/images/tests/');
				$img = $uploaded->getClientName();
			}
			$id = $this->model->insert([
				'name' => $this->request->getPost('name'),
				'test_code' => $this->request->getPost('test_code'),
				'base_price' => $this->request->getPost('base_price'),
				'service_id' => $this->request->getPost('service_id'),
				'is_active' => $this->request->getPost('is_active'),
				'description' => $this->request->getPost('description'),
				'image' => $img
			]);
			$patho_id = $this->request->getPost('patho_id');
			$mrp = $this->request->getPost('mrp');
			$orgprice = $this->request->getPost('orgprice');
			$medicooffer = $this->request->getPost('medicooffer');
			if(!empty($patho_id)) {
				$i = 0;
				foreach ($patho_id as $key => $value) {
					$ins = [
						'test_id' => $id,
						'patho_id' => $value,
						'mrp' => $mrp[$i],
						'orgprice' => $orgprice[$i],
						'medicooffer' => $medicooffer[$i]
					];
					$builder = $this->db->table('tbl_testbypath');
					$builder->insert($ins);
					$i++;
				}
			}
			session()->setFlashdata('success', 'New test added successfully.');
			return redirect()->to(base_url('admin/tests/add'));
		}
		echo view('admin/tests/add', $data);
	}

	public function getPathologies() {
		if ($this->request->isAJAX()) { 
			$id = $this->request->getPost('id');
			$builder = $this->db->table('tbl_testbypath');
			$result = $builder->getWhere(['test_id' => $id])->getResultArray();
			return $this->response->setJSON($result);
		} else {
			throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
		}
	}
	
	public function remove($id) {
		if($id!='') {
			$builder = $this->db->table('tbl_testbypath');
			$builder->where('test_id', $id);
			$builder->delete();
			$this->model->delete($id);	
			session()->setFlashdata('success', 'Selected test removed successfully.');
			return redirect()->to(base_url('admin/tests/'));
		} else {
			throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
		}
	}

	public function remove_img() 
	{
		if ($this->request->isAJAX()) { 
			$id = $this->request->getPost('id');
			$img = $this->request->getPost('img');
			$file = 'public/assets/images/tests/'.$img;
			$array = array('image' => '');
			$this->model->update($id, $array);
			if(is_readable($file)) {	
				unlink($file);
			}
		} else {
			throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
		}
	}

}
