<?php namespace App\Controllers;
use App\Controllers\BaseController;

//use App\Libraries\Razorpay\Razorpay\Api\Api;
//use App\Libraries\Razorpay\Razorpay\Api\Errors\SignatureVerificationError;
class Checkout extends BaseController


{
    protected $db;
 
    public function __construct() {
        $this->db      = \Config\Database::connect();
    }
 
    public function index()
    {
        $data['items'] = $this->cart->totals();
        
        $discount = session()->get('discount');
        $code = $discountAmount = '';
        $totalAmount = $this->cart->count_totals();
        if(!empty($discount)) :
            $code = $discount['code'];
            $discountAmount = $discount['discountAmount'];
            $totalAmount = $totalAmount - $discount['discountAmount'];
        endif;
        $orderData = [
            //'receipt' => 3456,
            'amount' => floatval($totalAmount) * 100, // 2000 rupees in paise
            'currency' => 'INR',
            'payment_capture' => 1 // auto capture
        ];
        $data['razorpayOrder'] = $this->razor->order->create($totalAmount);
        print_r($data['razorpayOrder']); die();
        
        if($this->request->getMethod() == 'post') {
            if(!$this->checkLogin) {
                session()->setFlashdata('error', 'You are not logged in, please login and proceed to checkout.');
                return redirect()->to(base_url());
            }            
            if(empty($data['items'])) {
                session()->setFlashdata('error', 'Your cart is empty.');
                return redirect()->to(base_url());
            }
            $q = $this->db->table('tbl_orders')->selectMax('order_id')->get()->getRowObject();
            if ($q->order_id == 0) {
                $q->order_id = 1233;
            }
            $order_id = $q->order_id + 1;
            $products = serialize($data['items']);
            
            
            $this->db->table('tbl_orders')->insert([
                'order_id' => $order_id,
                'payment_type' => $this->request->getPost('payment_type'),
                'transaction_id' => '',
                'products' => $products,
                'user_name' => $this->request->getPost('name'),
                'mobile' => $this->request->getPost('mobile'),
                'email' => $this->request->getPost('email'),
                'address' => $this->request->getPost('address'),
                'address2' => $this->request->getPost('address2'),
                'city' => $this->request->getPost('city'),
                'state' => $this->request->getPost('state'),
                'country' => $this->request->getPost('country'),
                'pincode' => $this->request->getPost('pincode'),
                'user_id' => session()->get('logged_user'),
                'status' => 'Pending',
                'discount_code' => $code,
                'total_price' => $totalAmount,
                'discount_price' => $discountAmount
            ]);
            if($this->request->getPost('saveAddress')=='1') {
                if ($this->db->table('tbl_customer_address')->where(['user_id'=> session()->get('logged_user')])->countAllResults() > 0) {
                    $this->db->table('tbl_customer_address')->where('user_id', session()->get('logged_user'))->update([
                        'address' => $this->request->getPost('address'),
                        'address2' => $this->request->getPost('address2'),
                        'city' => $this->request->getPost('city'),
                        'state' => $this->request->getPost('state'),
                        'country' => $this->request->getPost('country'),
                        'pincode' => $this->request->getPost('pincode')
                    ]);
                } else {
                    $this->db->table('tbl_customer_address')->insert([
                        'address' => $this->request->getPost('address'),
                        'address2' => $this->request->getPost('address2'),
                        'city' => $this->request->getPost('city'),
                        'state' => $this->request->getPost('state'),
                        'country' => $this->request->getPost('country'),
                        'pincode' => $this->request->getPost('pincode'),
                        'user_id' => session()->get('logged_user')
                    ]);
                }
            }            
        }
        $data['title'] = 'Medicoserve - Checkout';
        $data['user'] = $this->db->table('tbl_customers')->select('name, mobile, email')->getWhere(['id' => session()->get('logged_user')])->getRowArray();
        $data['address'] = $this->db->table('tbl_customer_address')->getWhere(['user_id' => session()->get('logged_user')])->getRowArray();
        $data['total'] = $this->cart->count_totals();
        $this->breadcrumb->add('Home', base_url());
		$this->breadcrumb->add('Checkout', base_url('/checkout'));
		$data['breadcrumb'] = $this->breadcrumb->render();
        return view('checkout', $data);
    }

    public function check_promocode() {
        if ($this->request->isAJAX()) {
            $result = [];
            $result['is_remove'] = $this->request->getPost('remove');
            if($this->request->getPost('remove')=='no') {
                $currentDate = date('Y-m-d',strtotime(date('Y-m-d')));
                $query = $this->db->table('tbl_offers')->select('discount, discount_code_type as type')->getWhere([
                    'type' => 'promocode', 
                    'discount_code'=> $this->request->getPost('enteredCode'),
                    'time_start <=' => $currentDate, 
                    'time_end >=' => $currentDate
                ])->getRowArray();
                if (is_array($query)) {
                    $totalPrice = $this->cart->count_totals();
                    $result['type'] = $query['type'];
                    $result['discountMainAmount'] = $query['discount'];
                    if($query['type']=='percent') {
                        $substract_num = ($query['discount'] / 100) * $totalPrice;
                        $result['finalAmount'] = $totalPrice - $substract_num;
                        $result['dicountAmount'] = $substract_num;
                    } else {
                        $result['finalAmount'] = $totalPrice - $query['discount'];
                        $result['dicountAmount'] = $query['discount'];
                    }
                    session()->set('discount', ['code' =>$this->request->getPost('enteredCode'), 'discountAmount' => $result['dicountAmount'], 'finalAmount' => $result['finalAmount'], 'type' => $query['type'], 'amount' => $query['discount']]);
                    $result['status'] = 1;
                } else {
                    session()->remove('discount');
                    $result['status'] = 0;                    
                }
            } else {
                session()->remove('discount');
                $result['finalAmount'] = $this->cart->count_totals();
                $result['status'] = 1;
            }
            return $this->response->setJSON($result);
		} else {
			throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
		}
    }
}
