<?php namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\Tests_model;

class Home extends BaseController
{
    protected $db;
    protected $test;
    protected $breadcrumb;

    public function __construct()
    {
        $this->db = \Config\Database::connect();
        $this->tests = new Tests_model;
        $this->breadcrumb = [];
    }

    public function index()
    {
        //$tests = $this->db->table('tbl_tests')->getWhere(['is_active'=> 1])->getResultArray();
        //$builder = $this->db->table('tbl_testbypath');
        // $nums = [ 0=>5, 1=>8, 2=>10, 3=>12, 4=>15];
        // foreach($tests as $t) {
        //     $key = array_rand($nums);
        //     $inc = $nums[$key];
        //     $ins = [
        //				'test_id' => $t['id'],
        //					'patho_id' => 10,
        //				'mrp' => $t['base_price']+$inc,
        //				'orgprice' => $t['landing_price_rate40']+$inc,
        //				'medicooffer' => $t['fluctuating_price_rate50']+$inc
        //			];
        //			$builder->insert($ins);
        // }
        //  die('done');
        $data['title'] = 'Medicoserve - Home';
        $data['pathologies'] = $this->db->table('tbl_pathologies')->get()->getResultArray();
        $data['tests'] = $this->db->table('tbl_tests')->getWhere(['is_active'=> 1], 20)->getResultArray();
        if(!empty($data['tests'])) {
            foreach($data['tests'] as &$t) {
                $price = $this->db->table('tbl_testbypath')->selectMin('medicooffer')->getWhere(['test_id' => $t['id']])->getRowArray();
                $t['price'] = $price['medicooffer'];
            }
            unset($t);
        }
        return view('home', $data);
    }
    
    public function about_us()
    {
        $this->breadcrumb->add('Home', base_url());
        $this->breadcrumb->add('About Us', base_url('/about-us'));
        $data = [
            'title' => 'About Us - Medicoserve',
            'breadcrumb' => $this->breadcrumb->render()
        ];
        return view('aboutus', $data);
    }
    
    public function terms()
    {
        $this->breadcrumb->add('Home', base_url());
        $this->breadcrumb->add('Terms and conditions', base_url('/terms-and-conditions'));
        $data = [
            'title' => 'Terms & Conditions - Medicoserve',
            'breadcrumb' => $this->breadcrumb->render()
        ];
        return view('terms', $data);
    }
    
    public function privacy()
    {
        $this->breadcrumb->add('Home', base_url());
        $this->breadcrumb->add('Privacy Policy', base_url('/privacy-policy'));
        $data = [
            'title' => 'Privacy Policy - Medicoserve',
            'breadcrumb' => $this->breadcrumb->render()
        ];
        return view('privacy', $data);
    }

    public function manageShoppingCart()
    {
        if (!$this->request->isAJAX()) {
            exit('No direct script access allowed');
        }
        $action = $this->request->getPost('action');
        $testid = $this->request->getPost('test_id');
        $tbpid = $this->request->getPost('tbpid');
        if($action=='add') {
            $test = $this->tests->getTestByIdandPath($testid, $tbpid);
            $items = [
                'id' => $test['test']['id'],
                'name' => $test['test']['name'],
                'image' => $test['test']['image'],
                'price' => $test['path']['medicooffer'],
                'patho_id' => $test['path']['id'],
                'patho_name' => $test['path']['pathname'],
                'quantity' => 1
            ];
            $cc = $this->cart->add_cart($testid, $items);
            $return['message'] = 'Item successfully added to cart';
            $return['success'] = true;
        } elseif($action=='remove') {
            $test = $this->tests->getTestByIdandPath($testid, $tbpid);
            if($test != null) {
                $this->cart->remove($testid);
                $return['message'] = 'Item successfully removed from cart';
                $return['success'] = true;
            } else {
                $return['message'] = 'Cannot find test data';
                $return['success'] = false;
            }
        } elseif($action=='update') {
            $this->cart->update($testid, $_POST['quantity']);
            $return['message'] = 'Cart updated.';
            $return['success'] = true;
        }
        $return['items'] = $this->cart->totals();
        $return['total'] = $this->cart->count_totals();
        return $this->response->setJSON($return);
    }

    //--------------------------------------------------------------------
}
