<?php namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\Pathologies_model;

class Labs extends BaseController
{
	protected $model;

	public function __construct()
	{
		$this->model = new Pathologies_model();
	}

	public function index()
	{
		$this->breadcrumb->add('Home', base_url());
        $this->breadcrumb->add('Labs', base_url('/labs'));
		$data = [
			'title' => 'Labs - Medicoserve',
			'labs' => $this->model->paginate(2),
			'breadcrumb' => $this->breadcrumb->render(),
			'pager' => $this->model->pager
		];
		return view('labs', $data);
	}

	//--------------------------------------------------------------------

}
