<?php namespace App\Controllers;

use App\Models\Tests_model;

class Tests extends BaseController
{
	protected $model;
	protected $db;
	
	public function __construct()
	{
		$this->model = new Tests_model();
		$this->db = \Config\Database::connect();
	}

	public function index()
	{
		$this->breadcrumb->add('Home', base_url());
        $this->breadcrumb->add('Tests', base_url('/tests'));
		$data = [
			'title' => 'Tests - Medicoserve',
			'services' => $this->db->table('tbl_services')->get()->getResultObject(),
			'tests' => $this->model->getTests($this->request->getGet()),
			'breadcrumb' => $this->breadcrumb->render(),
			'pager' => $this->model->pager
		];
		return view('tests', $data);
	}

	public function page($title=NULL, $pid=NULL)
	{
		if($title==NULL || $pid==NULL) {
			show_404();
		}
		$id = decode_url($pid);
		$data['test'] = $this->model->select('tbl_tests.*, tbl_services.name as service_name')->join('tbl_services', 'tbl_tests.service_id=tbl_services.id', 'left')->getWhere(['tbl_tests.id'=> $id])->getRowArray();
		if(empty($data['test'])) {

		}
		$data['path'] = $this->db->table('tbl_testbypath tbp')->select('tbp.*, t.name as pathname, t.address, t.image, t.description, c.name as city_name, s.name as state_name')->join('tbl_pathologies t', 'tbp.patho_id=t.id', 'inner')->join('master_city c', 't.city_id=c.id', 'left')->join('master_state s', 't.state_id=s.id', 'right')->getWhere(['tbp.test_id'=> $id])->getResultArray();
		$data['title'] = ucfirst($data['test']['name']);
		$this->breadcrumb->add('Home', base_url());
		$this->breadcrumb->add('Tests', base_url('/tests'));
		$this->breadcrumb->add(ucfirst($data['test']['name']), base_url('/tests'));
		$data['breadcrumb'] = $this->breadcrumb->render();
		echo view('singletest', $data);
	}

	//--------------------------------------------------------------------

}
