<?php namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\Customers_model;
use App\Models\Address_model;

class Users extends BaseController
{
    protected $user_id, $model, $address;
    private $registerErrors;

    
    public function __construct()
    {
        $this->model = new Customers_model();
        $this->address = new Address_model();
    }

    public function index()
    {
        if(!$this->checkLogin) {
            session()->setFlashdata('error', 'You are not logged in, please login to continue.');
            return redirect()->to(base_url());
        }
        $data['title'] = 'Medicoserve - Home';    
        if($this->request->getMethod() == 'post') {
            $this->model->update(session()->get('logged_user'), [
                'name' => $this->request->getPost('name'),
                'email' => $this->request->getPost('email'),
                'gender' => $this->request->getPost('gender'),
                'age' => $this->request->getPost('age')
            ]);
            session()->setFlashdata('success', 'Profile updated successfully.');            
            return redirect()->to(base_url('/my-account'));
        }
        $this->breadcrumb->add('Home', base_url());
        $this->breadcrumb->add('My Account', base_url('/my-accunt'));
        $data['breadcrumb'] = $this->breadcrumb->render();
        $data['user'] = $this->model->find(session()->get('logged_user'));
        $data['address'] = $this->address->where('user_id', session()->get('logged_user'))->first();
        return view('account', $data);
    }

    public function register()
    {
        if($this->checkLogin) {
            return $this->response->setJSON(['status' => 0, 'message'=> 'User already logged in']);
        }
        if ($this->request->isAJAX()) {
            $data = array();
            if($this->request->getPost('otp') == '') {
                $data['type'] = 'sending_otp';
                $result = $this->registerValidate();
                if ($result == false) {
                    $errors = '';
                    foreach($this->registerErrors as $key => $value) :
                        $errors .= $value.'<br>';
                    endforeach;
                    $data['message'] = rtrim($errors,'<br>');
                    $data['status'] = 0;
                } else {
                    session()->set('register_user_id', $this->user_id);
                    $data['message'] = 'Otp sent to your mobile no.';
                    $data['status'] = 1;
                }
            } else {
                $data['type'] = 'matching_otp';
                $errors = '';
                if ($this->model->asArray()->where(['id' => session()->get('register_user_id'), 'otp' => $this->request->getPost('otp'), 'status'=>0])->countAllResults() > 0) {
                    $this->model->save([
                        'id' => session()->get('register_user_id'),
                        'status' => 1,
                        'otp' => ''
                    ]);
                    session()->set('logged_user', session()->get('register_user_id'));
                    session()->remove('register_user_id');
                    $data['message'] = 'User registered';
                    $data['status'] = 1;
                } else {
                    $errors = 'OTP did not match, please try again.';
                    $data['message'] = $errors;
                    $data['status'] = 0;
                }
            }
            return $this->response->setJSON($data);
        }
    }

    private function registerValidate()
    {
        $otp = mt_rand(1000,9999);
        $otp = '1234';
        if ($this->model->where('mobile',$this->request->getPost('mobile'))->countAllResults() > 0) {
            $query = $this->model->where(['mobile'=> $this->request->getPost('mobile'), 'status' => 0])->first();
            if($query['status']=='0') {
                $this->model->update($query['id'], [
                    'name' => $this->request->getPost('name'),
                    'otp' => $otp
                ]);
                $this->user_id = $query['id'];
                return true;
            } else {
                $this->registerErrors = ['notfound' => 'This number already registered, please try login.'];
                return false;
            }            
        } else {
            $this->model->save([
                'name' => $this->request->getPost('name'),
                'mobile' => $this->request->getPost('mobile'),
                'otp' => $otp,
                'status' => 0,
            ]);
            $this->user_id = $this->model->insertID();
            return true;
        }  
    }

    public function login()
    {
        if($this->checkLogin) {
            return $this->response->setJSON(['status' => 0, 'message'=> 'User already logged in']);
        }
        if ($this->request->isAJAX()) {
            $data = array();
            if($this->request->getPost('otp') == '') {
                $data['type'] = 'sending_otp';
                $result = $this->model->where(['mobile'=> $this->request->getPost('mobile'), 'status' => 1])->first();
                if (is_array($result)) {
                    $otp = mt_rand(1000,9999);
                    $otp = '1234';
                    $this->model->update($result['id'], [
                        'otp' => $otp
                    ]);
                    session()->set('login_user_id', $result['id']);
                    $data['message'] = 'Otp sent to your mobile no.';
                    $data['status'] = 1;
                } else {
                    $data['message'] = 'Mobile number not availabe or account inactive try Sign up';
                    $data['status'] = 0;
                }
            } else {
                $data['type'] = 'matching_otp';
                $checkOtp = $this->model->where(['id'=> session()->get('login_user_id'), 'otp'=> $this->request->getPost('otp'), 'status' => 1])->first();
                if (is_array($checkOtp)) {
                    $this->model->update($checkOtp['id'], [
                        'otp' => ''
                    ]);
                    session()->set('logged_user', $checkOtp['id']);
                    session()->remove('login_user_id');
                    $data['message'] = 'User logged in';
                    $data['status'] = 1;
                } else {
                    $data['message'] = 'Please check the otp you entered.';
                    $data['status'] = 0;
                }
            }
            return $this->response->setJSON($data);
        }
    }

    public function changeMobile()
    {
        if(!$this->checkLogin) {
            return $this->response->setJSON(['status' => 0, 'message'=> 'User not logged in']);
        }
        if ($this->request->isAJAX()) {
            $data = array();
            if($this->request->getPost('otp') == '') {
                $data['type'] = 'sending_otp';
                if ($this->model->where(['mobile'=>$this->request->getPost('mobile'), 'id !=' => session()->get('logged_user')])->countAllResults() > 0) {
                    $data['message'] = 'Mobile number already taken';
                    $data['status'] = 0;
                } else {
                    $otp = mt_rand(1000,9999);
                    $otp = '1234';
                    $this->model->update(session()->get('logged_user'), [
                        'mobile' => $this->request->getPost('mobile'),
                        'otp' => $otp
                    ]);
                    $data['message'] = 'Otp sent to your mobile no.';
                    $data['status'] = 1;
                }
            } else {
                $data['type'] = 'matching_otp';
                $checkOtp = $this->model->where(['id'=> session()->get('logged_user'), 'otp'=> $this->request->getPost('otp'), 'status' => 1])->first();
                if (is_array($checkOtp)) {
                    $this->model->update($checkOtp['id'], [
                        'otp' => ''
                    ]);
                    $data['message'] = 'Mobile Number changed successfully.';
                    $data['status'] = 1;
                } else {
                    $data['message'] = 'Please check the otp you entered.';
                    $data['status'] = 0;
                }
            }
            return $this->response->setJSON($data);
        }
    }

    public function update_address() {
        if(!$this->checkLogin) {
            session()->setFlashdata('error', 'You are not logged in, please login to continue.');
            return redirect()->to(base_url());
        }
        if($this->request->getMethod() == 'post') {
            if ($this->address->where(['user_id'=> session()->get('logged_user')])->countAllResults() > 0) {
                $this->address->where('user_id', session()->get('logged_user'))->set([
                    'address' => $this->request->getPost('address'),
                    'address2' => $this->request->getPost('address2'),
                    'city' => $this->request->getPost('city'),
                    'state' => $this->request->getPost('state'),
                    'country' => $this->request->getPost('country'),
                    'pincode' => $this->request->getPost('pincode')
                ])->update();
                session()->setFlashdata('success', 'Address updated successfully.');
                return redirect()->to(base_url('/my-account'));
            } else {
                $this->address->save([
                    'address' => $this->request->getPost('address'),
                    'address2' => $this->request->getPost('address2'),
                    'city' => $this->request->getPost('city'),
                    'state' => $this->request->getPost('state'),
                    'country' => $this->request->getPost('country'),
                    'pincode' => $this->request->getPost('pincode'),
                    'user_id' => session()->get('logged_user')
                ]);
                session()->setFlashdata('success', 'Address added successfully.');
                return redirect()->to(base_url('/my-account'));
            }    
        } else {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound('Not Allowed');
        }
    }

    public function profileimageupload () {
        if ($this->request->isAJAX()) :
            if(!$this->checkLogin) {
                return $this->response->setJSON(['status' => 0, 'message'=> 'User not logged in']);
            }
            $validated = $this->validate([
                'userpic' => [
                    'uploaded[userpic]',
                    'mime_in[userpic,image/jpg,image/jpeg,image/gif,image/png]',
                    'max_size[userpic,4096]',
                ],
            ]);	  
            if($validated) {
                $query = $this->model->select('profile_img')->where(['id'=> session()->get('logged_user')])->first();
                $this->profile_image_remove($query['profile_img']);
                $profile = $this->request->getFile('userpic');
                $profile->move('public/assets/images/profile/');
                $profile_img = $profile->getClientName();
                $this->model->update(session()->get('logged_user'), [
                    'profile_img' => $profile_img
                ]);
                $result['image'] = $profile_img;
                $result['status'] = true;
                $result['message'] = 'Profile image uploaded successfully.';
            } else {
                $result['status'] = false;
                $result['message'] = 'Please check the image you are uploading.';
            }
            return $this->response->setJSON($result);
        else :
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
        endif;
    }

    private function profile_image_remove($file) {
        $imagepath = 'public/assets/images/profile/'.$file;
        if(is_readable($imagepath)) {	
            unlink($imagepath);
            return true;
        } else {
            return false;
        }
    }

    public function remove_img() 
	{
		if ($this->request->isAJAX()) {
            if(!$this->checkLogin) {
                return $this->response->setJSON(['status' => 0, 'message'=> 'User not logged in']);
            }
			$this->model->update(session()->get('logged_user'), ['profile_img' => '']);
			$this->profile_image_remove($this->request->getPost('img'));
            $result['status'] = true;
            $result['message'] = 'Profile image uploaded successfully.';
            return $this->response->setJSON($result);
		} else {
			throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
		}
	}

    public function logout() {
        session()->remove('logged_user');
		return redirect()->to(base_url());
    }
}
