<?php
use App\Libraries\WFcart;

function getName($table, $select, $id)
{
    $db = \Config\Database::connect();
    $builder = $db->table($table)->select('' . $select . '')->getWhere(['id' => $id])->getRowArray();
    return $builder[$select];
}

function getResultAllFunc($table, $select, $where = null)
{
    $db = \Config\Database::connect();
    if ($where == null) {
        $builder = $db->table($table)->select('' . $select . '')->get()->getResultArray();
    } else {
        $builder = $db->table($table)->select('' . $select . '')->getWhere($where)->getResultArray();
    }
    return $builder;
}

function getCounts($table)
{
    $db = \Config\Database::connect();
    return $db->table($table)->countAll();
}

function slugify($string)
{
    helper('text');
    $slug = url_title(convert_accented_characters($string), '-', true);
    return $slug;
}

function encode_url($string)
{
    $encrypt_method = "AES-256-CBC";
    $secret_key = 'servoMedoco';
    $secret_iv = 'servo';
    $key = hash('sha256', $secret_key);
    $iv = substr(hash('sha256', $secret_iv), 0, 16);
    $output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
    return base64_encode($output);
}

function decode_url($string)
{
    $encrypt_method = "AES-256-CBC";
    $secret_key = 'servoMedoco';
    $secret_iv = 'servo';
    $key = hash('sha256', $secret_key);
    $iv = substr(hash('sha256', $secret_iv), 0, 16);
    return openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
}

function getCartItems()
{
    $cart = new WFcart();
    return [
    'items' => is_array($cart->totals()) ? $cart->totals() : [],
    'total' => $cart->count_totals()
    ];
}


function validate_fields($arrayData, $requiredKeys)
{
    foreach ($requiredKeys as $key) {
        if (!array_key_exists($key, $arrayData)) {
            // Key is missing
            return false;
        }
    }
    return true;
}

function validate_phone_number($phone_number)
{
    $pattern = '/^[0-9]{10}$/';
    if (!preg_match($pattern, $phone_number)) {
        return false;
    }
    return true;
}

function query_debug()
{
    $db = \Config\Database::connect();
    $lastQuery = $db->getLastQuery();
    echo $lastQuery;
    die();
}
