<?php

/* Breadcrumbs library for Codeigniter 4 with Bootstrap 4 */

namespace App\Libraries;
class Breadcrumbs {

	private $breadcrumbs = array();
	private $tags = array();
	
	public function __construct()
	{
		$this->tags['open'] = '<ol class="breadcrumb bg-dark mb-0 arr-right">';
		$this->tags['close'] = '</ol>';
		$this->tags['itemOpen'] = '<li class="breadcrumb-item">';
		$this->tags['itemClose'] = '</li>';
	}

	public function add($title, $href){		
		if (!$title OR !$href) return;
		$this->breadcrumbs[] = array('title' => $title, 'href' => $href);
	}
	
	private function openTag($tags=""){
		if(empty($tags)){
			return $this->tags['open'];
		}else{
			$this->tags['open'] = $tags;
		}
	}
	
	private function closeTag($tags=""){
		if(empty($tags)){
			return $this->tags['close'];
		}else{
			$this->tags['close'] = $tags;
		}
	}
	
	private function itemOpenTag($tags=""){
		if(empty($tags)){
			return $this->tags['itemOpen'];
		}else{
			$this->tags['itemOpen'] = $tags;
		}
	}
	
	private function itemCloseTag($tags=""){
		if(empty($tags)){
			return $this->tags['itemClose'];
		}else{
			$this->tags['itemClose'] = $tags;
		}
	}
	
	public function render() {
		if(!empty($this->tags['open'])){
			$output = $this->tags['open'];
		}else{
			$output = '<ol class="breadcrumb">';
		}		
		$count = count($this->breadcrumbs)-1;
		foreach($this->breadcrumbs as $index => $breadcrumb) {		
			if($index == $count){
				$output .= '<li class="breadcrumb-item active">';
				$output .= $breadcrumb['title'];
				$output .= '</li>';
			}else{
				$output .= ($this->tags['itemOpen'])?$this->tags['itemOpen']:'<li class="breadcrumb-item">';
				$output .= '<a href="'.$breadcrumb['href'].'">';
				$output .= $breadcrumb['title'];
				$output .= '</a>';
				$output .= '</li>';
			}			
		}		
		if(!empty($this->tags['open'])){
			$output .= $this->tags['close'];
		}else{
			$output .= "</ol>";
		}
		return $output;
	}
}
