<?php namespace App\Models;

use CodeIgniter\Model;

class Adminmodel extends Model
{
	protected $table 		= 'users';
	protected $primaryKey 	= 'id';
	protected $allowedFields = ['email','username','password', 'profile_image', 'last_login', 'role', 'registered_date'];
	
	// Listing
	public function listing()
	{
		$this->select('*');
		$query = $this->get();
		return $query->getResultArray();
	}

	// Detail
	public function detail($id_user)
	{
		$this->select('*');
		$this->where(array(	'id_user'	=> $id_user));
		$query = $this->get();
		return $query->getRowArray();
	}

	// Detail
	public function checkUser($data)
	{
		$this->select('*');
		$this->where(array('username'	=> $data['username']));
		$query = $this->get();		
		$result = $query->getRowArray();
		if(isset($result['password']) && $result['password']!=='') {
    		if(password_verify($data['password'], $result['password'])) {
    			$this->set(array('last_login' => date('Y-m-d H:i:s')))->where('id', $result['id'])->update();
    			return $result;
    		} else {
    			return false;
    		}
		} else {
		    return false;
		}
	}
	// Edit
	public function edit($data)
	{
		$this->where('id_user',$data['id_user']);
		$this->replace($data);
	}

	// Delete
	public function hapus($id_user)
	{
		$this->where('id_user',$id_user);
		$this->delete();
	}
}