<?php namespace App\Models;

use CodeIgniter\Model;

class Tests_model extends Model
{
	protected $table 		= 'tbl_tests';
	protected $primaryKey 	= 'id';
	protected $allowedFields = ['name', 'service_id', 'is_active', 'image', 'description', 'test_code', 'sample', 'methodology', 'temp', 'schedule', 'reporting', 'base_price', 'fluctuating_price_rate50', 'landing_price_rate40'];

	public function getTests($filters = null) {
		if($filters!==NULL) {
			if(@$filters['service'] != '') {
				$this->where(['service_id' => $filters['service']]);
			}
			if(@$filters['search'] != '') {
				$this->like(['name' => $filters['search']]);
			}
		}
		return $this->select('tbl_tests.*, tbl_testbypath.medicooffer as minprice')->join('tbl_testbypath', 'tbl_testbypath.test_id = tbl_tests.id AND tbl_testbypath.medicooffer = (SELECT MIN(medicooffer) FROM tbl_testbypath WHERE test_id = tbl_tests.id)', 'left')->where(['is_active'=> '1'])->paginate(16);
	}

	public function getTestByIdandPath($testid, $tbpid) {
		$data['test'] = $this->select('tbl_tests.id, tbl_tests.name, tbl_tests.image')->getWhere(['tbl_tests.id'=>
		$testid])->getRowArray();
		if($tbpid !=0) :
		    $this->db = \Config\Database::connect();
			$data['path'] = $this->db->table('tbl_testbypath tbp')->select('tbp.id, tbp.medicooffer, tbp.patho_id ,t.name as pathname, t.address, t.image')->join('tbl_pathologies t', 'tbp.patho_id=t.id', 'left')->getWhere(['tbp.id'=> $tbpid, 'tbp.test_id' => $testid])->getRowArray();
		endif;
		return $data;
	}
}