<?= view('template/header'); ?>
<section class="outer-page-section pt-5 pb-3">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <h2>Profile</h2>
            </div>
        </div>
        <div class="row">
            <div class="col pathlist">
                <div class="card card-nav-tabs card-plain mt-5">
                    <div class="card-header card-header-danger">
                        <div class="nav-tabs-navigation">
                            <div class="nav-tabs-wrapper">
                                <ul class="nav nav-tabs" data-tabs="tabs">
                                    <li class="nav-item">
                                        <a class="nav-link active" href="#profile-tab" data-toggle="tab">Account</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" href="#orders-tab" data-toggle="tab">Orders</a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="card-body shadow">
                        <div class="tab-content">
                            <div class="tab-pane active" id="profile-tab">
                                <div class="row">
                                    <div class="col-12">
                                        <div class="myaccount mt-5">
                                            <h3 class="main-heading mt-2">Account Details <span
                                                    class="ml-3 fs13"><button type="button" data-target="#userModal"
                                                        class="btn btn-sm btn-info" data-toggle="modal"
                                                        style="position:relative;top:-5px"><i class="far fa-edit"></i>
                                                        Edit Profile</button></span></h3>
                                            <div class="row">
                                                <div class="col-12 col-sm-6 col-md-4">
                                                    <div class="d-flex justify-content-center align-items-center dropzone-mask">
                                                        <?php if(@$user['profile_img'] && $user['profile_img'] !='') : ?>
                                                        <button type="button" data-placement="top" data-img="<?= @$user['profile_img'];?>"
                                                            title="Remove Profile Image" data-toggle="tooltip"
                                                            class="btn btn-lg btn-danger removeImg"><i
                                                                class="fas fa-trash"></i></button>
                                                        <?php endif;?>
                                                        <div id="drop_zone" data-placement="top"
                                                            title="Drag & Drop or Click to Upload Profile Image"
                                                            data-toggle="tooltip"
                                                            class="drop-zone <?= @$user['profile_img'] && $user['profile_img'] !='' ? 'drop' : '';?>">
                                                            <p class="title">Drop Image here</p>
                                                            <div class="preview-container">
                                                                <?php if(@$user['profile_img'] && $user['profile_img'] !='') : ?>
                                                                <div class="preview">
                                                                    <img src="<?= base_url('/public/assets/images/profile/'.$user['profile_img']);?>"
                                                                        style="width:110%;">
                                                                </div>
                                                                <?php endif;?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="uploader-info">
                                                        <div class="file-uploader-progress-bar invisible progress">
                                                            <div class="progress-bar progress-bar-striped bg-success"
                                                                role="progressbar" style="width: 0%" aria-valuenow="25"
                                                                aria-valuemin="0" aria-valuemax="100"></div>
                                                        </div>
                                                        <button type="button" class="btn btn-dark shimmer"
                                                            id="upload_images">Upload Profile Image</button>
                                                        <input id="profileImageUpload" accept="image/*" type="file"
                                                            multiple name="file">
                                                    </div>
                                                </div>
                                                <div class="col-12 col-sm-8 col-md-8 mt-md-5">
                                                    <div class="row mt-md-5">
                                                        <div class="col-12 col-sm-6 col-md-4">
                                                            <p class="mt-2 mb-5">
                                                                <strong>Name</strong>
                                                                <?= @$user['name'];?>
                                                            </p>
                                                        </div>
                                                        <div class="col-12 col-sm-6 col-md-4">
                                                            <p class="mt-2 mb-5">
                                                                <strong>Mobile Number</strong>
                                                                <span
                                                                    class="showing_mobile"><?= @$user['mobile'];?></span>
                                                            </p>
                                                        </div>
                                                        <div class="col-12 col-sm-6 col-md-4">
                                                            <p class="mt-2 mb-5">
                                                                <strong>Email</strong>
                                                                <?= @$user['email'];?>
                                                            </p>
                                                        </div>
                                                        <div class="col-12 col-sm-6 col-md-4">
                                                            <p class="mt-2 mb-5">
                                                                <strong>Gender</strong>
                                                                <?= @$user['gender'];?>
                                                            </p>
                                                        </div>
                                                        <div class="col-12 col-sm-6 col-md-4">
                                                            <p class="mt-2 mb-5">
                                                                <strong>Age</strong>
                                                                <?= @$user['age'];?>
                                                            </p>
                                                        </div>
                                                        <div class="col-12 col-sm-6 col-md-4">
                                                            <p class="mt-2 mb-5">
                                                                <strong>Joined</strong>
                                                                <?= @date('d - m - Y',strtotime($user['registered_date']));?>
                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <hr class="w-100 mt-5">
                                    </div>
                                    <div class="col-12">
                                        <div class="myaccount mt-5">
                                            <h3 class="main-heading mt-2">Address <span class="ml-3 fs13"><button
                                                        type="button" data-target="#addressModal"
                                                        class="btn btn-sm btn-info" data-toggle="modal"
                                                        style="position:relative;top:-5px"><i class="far fa-edit"></i>
                                                        Edit Address</button></span></h3>
                                            <form method="post">
                                                <div class="row">
                                                    <div class="col-12 col-sm-6 col-md-4">
                                                        <p class="mt-2 mb-5">
                                                            <strong>Address 1</strong>
                                                            <?= @$address['address'];?>
                                                        </p>
                                                    </div>
                                                    <div class="col-12 col-sm-6 col-md-4">
                                                        <p class="mt-2 mb-5">
                                                            <strong>Address 2</strong>
                                                            <span><?= @$address['address2'];?></span>
                                                        </p>
                                                    </div>
                                                    <div class="col-12 col-sm-6 col-md-4">
                                                        <p class="mt-2 mb-5">
                                                            <strong>City</strong>
                                                            <?= @$address['city'];?>
                                                        </p>
                                                    </div>
                                                    <div class="col-12 col-sm-6 col-md-4">
                                                        <p class="mt-2 mb-5">
                                                            <strong>State</strong>
                                                            <?= @$address['state'];?>
                                                        </p>
                                                    </div>
                                                    <div class="col-12 col-sm-6 col-md-4">
                                                        <p class="mt-2 mb-5">
                                                            <strong>Country</strong>
                                                            <?= @$address['country'];?>
                                                        </p>
                                                    </div>
                                                    <div class="col-12 col-sm-6 col-md-4">
                                                        <p class="mt-2 mb-5">
                                                            <strong>Pincode</strong>
                                                            <?= @$address['pincode'];?>
                                                        </p>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<div class="modal fade" id="userModal" tabindex="-1" role="dialog" aria-labelledby="" aria-hidden="true">
    <div class="modal-dialog modal-dialog-slideout" role="document">
        <div class="modal-content">
            <form method="post">
                <div class="modal-header modal-header-danger">
                    <h5 class="modal-title" id="">Update Profile</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body shadow">
                    <div class="card shadow">
                        <div class="card-body">
                            <div class="form-group">
                                <label>Name</label>
                                <input type="text" class="form-control shadow" name="name" value="<?= @$user['name']?>">
                            </div>
                            <label>Mobile</label>
                            <div class="mobile-changer-form">
                                <div class="input-group mb-3">
                                    <input type="number" class="form-control shadow" name="mobile"
                                        value="<?= @$user['mobile']?>">
                                    <input type="number" class="form-control shadow otpInput d-none" name="otp"
                                        placeholder="Enter OTP here">
                                    <div class="input-group-append">
                                        <button class="btn btn-outline-secondary shadow changeMobileBtn"
                                            type="button">Change</button>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Email</label>
                                <input type="text" class="form-control shadow" name="email"
                                    value="<?= @$user['email']?>">
                            </div>
                            <div class="form-group">
                                <label>Gender</label>
                                <select class="form-control shadow" name="gender">
                                    <option <?= @$user['gender'] && $user['gender']=='Male' ? 'selected' : '';?>
                                        value="Male">Male</option>
                                    <option <?= @$user['gender'] && $user['gender']=='Female' ? 'selected' : '';?>
                                        value="Female">Female</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Age</label>
                                <input type="number" max="110" class="form-control shadow" name="age"
                                    value="<?= @$user['age']?>">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-dark shimmer">Save changes</button>
                </div>
            </form>
        </div>
    </div>
</div>
<div class="modal fade" id="addressModal" tabindex="-1" role="dialog" aria-labelledby="" aria-hidden="true">
    <div class="modal-dialog modal-dialog-slideout" role="document">
        <div class="modal-content">
            <form method="post" action="<?=base_url('/users/update-address')?>">
                <div class="modal-header modal-header-danger">
                    <h5 class="modal-title" id="">Add/Update Address</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body shadow">
                    <div class="card shadow">
                        <div class="card-body">
                            <div class="form-group">
                                <label>Address 1</label>
                                <input type="text" class="form-control shadow" name="address"
                                    value="<?= @$address['address']?>">
                            </div>
                            <div class="form-group">
                                <label>Address 2</label>
                                <input type="text" class="form-control shadow" name="address2"
                                    value="<?= @$address['address2']?>">
                            </div>
                            <div class="form-group">
                                <label>City</label>
                                <input type="text" class="form-control shadow" name="city"
                                    value="<?= @$address['city']?>">
                            </div>
                            <div class="form-group">
                                <label>State</label>
                                <input type="text" class="form-control shadow" name="state"
                                    value="<?= @$address['state']?>">
                            </div>
                            <div class="form-group">
                                <label>Country</label>
                                <input type="text" class="form-control shadow" name="country"
                                    value="<?= @$address['country']?>">
                            </div>
                            <div class="form-group">
                                <label>Pincode</label>
                                <input type="number" class="form-control shadow" name="pincode"
                                    value="<?= @$address['pincode']?>">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-dark shimmer">Save changes</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?= view('template/footer'); ?>
