<?= view('admin/template_part/header'); ?>
<?= view('admin/template_part/sidebar'); ?>
<!-- Main content -->
<div class="card">
  <div class="card-header">
    <h3 class="card-title"><?= $title;?></h3>
    <div class="card-tools">
      <button type="button" class="btn btn-tool" data-card-widget="collapse" data-toggle="tooltip" title="Collapse"> <i class="fas fa-minus"></i></button>
    </div>
  </div>
  <div class="card-body">
        <table id="defaultDatatables" class="table table-bordered table-condensed table-hover table-striped dt-responsive nowrap">
          <thead>
            <tr>
              <th>S.No</th>
              <th>Order ID</th>
              <th>Products</th>
              <th>Status</th>
              <th>Customer Info</th>
              <th>Total Amount</th>
              <th>Discount Code / Discount</th>
            </tr>
          </thead>
          <tbody>
            <?php $i = 1;foreach($list as $v) {
            $prod = unserialize($v['products']); 
            $cls = '';
            if($v['status']=='Pending') :
            $cls = 'bg-warning';
            elseif($v['status']=='Processed'):
            $cls = 'bg-primary';
            elseif($v['status']=='Cancelled'):
            $cls = 'bg-danger';
            elseif($v['status']=='Completed'):
            $cls = 'bg-success';
            endif;?>
            <tr>
              <td><?php echo $i;?></td>
              <td><?= $v['order_id'];?></td>
              <td><button type="button" class="btn md-btn btn-primary" data-toggle="modal" data-mytitle="Tests - #<?= $v['order_id']?>" data-target="#addToModal">View Tests</button>
                <div class="d-none addtocontent">
                    <?php foreach($prod as $p) :?>
                    <div class="row text-dark">
                        <div class="col">
                            <div class="card">
                                <div class="card-header p-2">
                                    <p class="mb-0">Test</p>
                                </div>
                                <div class="card-body">
                                    <p><?= $p['name'];?></p>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="card">
                                <div class="card-header p-2">
                                    <p class="mb-0">Image</p>
                                </div>
                                <div class="card-body">
                                    <?php if($p['image']=='') :?>
                                    <img src="<?= base_url('/public/assets/images/lab-test.jpg')?>" class="img-fluid">
                                    <?php else :?>
                                    <img src="<?= base_url('/public/assets/images/tests/'.$p['image'])?>" class="img-fluid">
                                    <?php endif;?>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="card">
                                <div class="card-header p-2">
                                    <p class="mb-0">Pathology</p>
                                </div>
                                <div class="card-body">
                                    <p><?= $p['patho_name'];?></p>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="card">
                                <div class="card-header p-2">
                                    <p class="mb-0">Quantity X Price</p>
                                </div>
                                <div class="card-body">
                                    <p><?= $p['quantity'];?> X Rs. <?= $p['price'];?></p>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="card">
                                <div class="card-header p-2">
                                    <p class="mb-0">Total</p>
                                </div>
                                <div class="card-body">
                                    <p>Rs. <?= $p['quantity'] * $p['price'];?></p>
                                </div>
                            </div>
                        </div>
                       
                    </div>
                     <?php endforeach;?>
                </div>
              </td>
              <td class="<?= $cls;?>">Current: <?= $v['status'];?><br>
                Change To: <br>
                <a type="button" href="<?php echo base_url('admin/bookings?bid='.$v['id']);?>&changeto=Pending" class="btn md-btn btn-warning">Pending</a>
                <a type="button" href="<?php echo base_url('admin/bookings?bid='.$v['id']);?>&changeto=Processed" class="btn md-btn btn-primary">Processed</a><br>
                <a type="button" href="<?php echo base_url('admin/bookings?bid='.$v['id']);?>&changeto=Cancelled" class="btn md-btn btn-danger">Cancelled</a>
                <a type="button" href="<?php echo base_url('admin/bookings?bid='.$v['id']);?>&changeto=Completed" class="btn md-btn btn-success">Completed</a></td>
              </td>
              <td>Name: <?= $v['user_name'];?><br>
              Mobile: <?= $v['mobile'];?><br>
              Email: <?= $v['email'];?><br>
              Address: <?= $v['address'];?>, <?= $v['address2'];?>, <?= $v['city'];?>, <?= $v['state'];?>, <?= $v['pincode'];?></td>
              <td>Rs. <?= $v['total_price'];?></td>
              <td><?= $v['discount_code'] == null ? 'Not Applied' : $v['discount_code'].' / Rs. -'. $v['discount_price'];?></td>
            </tr>
            <?php $i++;} ?>
          </tbody>
        </table>
    </div>
  </div>
<?= view('admin/template_part/footer'); ?>
<script>
$(document).ready(function(e) { 
	$('#defaultDatatables').DataTable({
        "ordering": false,
		dom: 'lBfrtip',
		stateSave: true,
		initComplete: function () {
            var i = 0;
            this.api().columns().every( function () {
                var cls = '';
                if(i==0 || i==1 || i==2 || i==3) {
                    cls = 'd-none';
                }
                var column = this;
                var select = $('<select class="form-control '+cls+'" style="widppth:180px"><option value="">Search</option></select>')
                    .appendTo( $(column.header()))
                    .on( 'change', function () {
                        var val = $.fn.dataTable.util.escapeRegex(
                            $(this).val()
                        ); 
                        column.search( val ? '^'+val+'$' : '', true, false).draw();
                    }); 
                column.data().unique().sort().each( function ( d, j ) {
                    select.append( '<option value="'+d+'">'+d+'</option>');
                });
                i++;
            });
        },
		buttons: [
			'excel', 'pdf'
		]
    });
});
</script>