<?= view('admin/template_part/header'); ?>
<?= view('admin/template_part/sidebar'); ?>
<!-- Main content -->
<style>
.thumbnail {
    position: relative;
}

.removeImg {
    color: red;
    cursor: pointer;
    position: absolute;
    top: 5px;
    right: 5px;
}
</style>
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><?= $title;?></h3>
        <div class="card-tools">
            <button type="button" class="btn btn-tool" data-card-widget="collapse" data-toggle="tooltip"
                title="Collapse"> <i class="fas fa-minus"></i></button>
        </div>
    </div>
    <div class="card-body">
        <table id="defaultDatatables"
            class="table table-bordered table-condensed table-hover table-striped dt-responsive nowrap">
            <thead>
                <tr>
                    <th>S.No</th>
                    <th width="180">Action</th>
                    <th>Fullname <br></th>
                    <th>Mobile No <br></th>
                    <th>Email<br></th>
                    <th>Profile Image</th>
                    <th>Age<br></th>
                    <th>Gender<br></th>
                    <th>Registered Date<br></th>
                </tr>
            </thead>
            <tbody>
                <?php $i = 1;foreach($list as $v) { ?>
                <tr>
                    <td><?= $i;?></td>
                    <td><button type="button" class="btn md-btn btn-primary" data-toggle="modal"
                            data-id="<?= $v['id'];?>" data-uname="<?= $v['name'];?>" data-mob="<?= $v['mobile'];?>"
                            data-email="<?= $v['email'];?>" data-age="<?= $v['age'];?>"
                            data-gender="<?= $v['gender'];?>" data-img="<?= $v['profile_img'];?>"
                            data-status="<?= $v['status'];?>" data-target="#editModal">Edit</button>
                        <a type="button" href="<?= base_url();?>/admin/customers/remove/<?= $v['id'];?>"
                            onclick="return ConfirmDelete();" class="btn md-btn btn-danger">Remove</a></td>
                    <td><?= $v['name'];?></td>
                    <td><?= $v['mobile'];?></td>
                    <td><?= $v['email'];?></td>
                    <td><img src="<?= base_url();?>/public/assets/images/profile/<?= $v['profile_img'];?>"
                            width="180" /></td>
                    <td><?= $v['age'];?></td>
                    <td><?= $v['gender'];?></td>
                    <td><?= $v['registered_date'];?></td>
                </tr>
                <?php $i++;} ?>
            </tbody>
        </table>
    </div>
</div>
<div id="editModal" class="modal fade modal-primary">
    <div class="modal-dialog modal-xl">
        <div class="modal-content bg-secondary">
            <div class="modal-header">
                <h4 class="modal-title">Update</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span></button>
            </div>
            <form role="form" method="post" action="" accept-charset="UTF-8" enctype="multipart/form-data">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="my-box">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="">Name</label>
                                            <input type="text" name="username" class="form-control"
                                                placeholder=" Enter Fullname" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="">Email</label>
                                            <input type="text" name="email" class="form-control"
                                                placeholder=" Enter Email">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="">Mobile Number</label>
                                            <input type="text" name="mobile" class="form-control"
                                                placeholder=" Enter Mobile no." required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="">Age</label>
                                            <input type="text" name="age" class="form-control" placeholder=" Enter Age">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="">Profile Image <span class="danger">(leave blank if don't want
                                                    to update image)</span></label>
                                            <input type="file" name="profile" class="form-control-file">
                                        </div>
                                        <div class="thumbnail modal-img"> <img class="img-thumbnail" src=""> <i
                                                class="far fa-times-circle fa-2x removeImg" data-id=""
                                                data-url="customers" data-img="" title="Remove this Image"></i>
                                            <input type="hidden" name="old_profileImg">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="">Gender</label>
                                            <select name="gender" class="form-control">
                                                <option value="">Select</option>
                                                <option value="Female">Female</option>
                                                <option value="Male">Male</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="">User Status</label>
                                            <select name="status" class="form-control">
                                                <option value="">Select</option>
                                                <option value="1">Activate</option>
                                                <option value="0">Deactivate</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="">Password <span class="danger">(leave blank if don't want to
                                                    update password)</span></label>
                                            <input type="text" name="password" class="form-control"
                                                placeholder=" Enter Password">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer justify-content-between">
                    <input type="hidden" name="id" value="">
                    <button type="button" class="btn btn-outline-light" data-dismiss="modal">Close</button>
                    <button type="reset" class="btn btn-outline-light">Reset</button>
                    <button type="submit" class="btn btn-outline-light">Save changes</button>
                </div>
            </form>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<?= view('admin/template_part/footer'); ?>
<script>
$(document).ready(function(e) {
    $('#editModal').on('shown.bs.modal', function(e) {
        $(this).find('input[name="id"]').val($(e.relatedTarget).data('id'));
        $(this).find('input[name="username"]').val($(e.relatedTarget).data('uname'));
        $(this).find('input[name="mobile"]').val($(e.relatedTarget).data('mob'));
        $(this).find('input[name="email"]').val($(e.relatedTarget).data('email'));
        $(this).find('input[name="age"]').val($(e.relatedTarget).data('age'));
        $(this).find('select[name="gender"]').val($(e.relatedTarget).data('gender'));
        $(this).find('.modal-img').hide();
        if ($(e.relatedTarget).data('img') != '') {
            $(this).find('.modal-img').show();
            $(this).find('input[name="old_profileImg"]').val($(e.relatedTarget).data('img'));
            jQuery(this).find('.removeImg').attr('data-id', $(e.relatedTarget).data('id'));
            $(this).find('.img-thumbnail').prop('src', base_url + '/public/assets/images/profile/' + $(e
                .relatedTarget).data('img'));
            jQuery(this).find('.removeImg').attr('data-img', $(e.relatedTarget).data('img'));
        }
        $(this).find('select[name="status"]').val($(e.relatedTarget).data('status'));
    })

    $('#defaultDatatables').DataTable({
        "ordering": false,
        dom: 'lBfrtip',
        stateSave: true,
        initComplete: function() {
            var i = 0;
            this.api().columns().every(function() {
                var cls = '';
                if (i == 0 || i == 1 || i == 5) {
                    cls = 'd-none';
                }
                var column = this;
                var select = $('<select class="form-control ' + cls +
                        '" style="width:auto"><option value="">Search</option></select>')
                    .appendTo($(column.header()))
                    .on('change', function() {
                        var val = $.fn.dataTable.util.escapeRegex(
                            $(this).val()
                        );
                        column.search(val ? '^' + val + '$' : '', true, false).draw();
                    });
                column.data().unique().sort().each(function(d, j) {
                    select.append('<option value="' + d + '">' + d + '</option>');
                });
                i++;
            });
        },
        buttons: [
            'excel', 'pdf'
        ]
    });
});
</script>