<?= view('admin/template_part/header'); ?>
<?= view('admin/template_part/sidebar'); ?>
<div class="card">
  <div class="card-header">
    <h3 class="card-title">
      <?= $title;?>
    </h3>
    <div class="card-tools">
      <button type="button" class="btn btn-tool" data-card-widget="collapse" data-toggle="tooltip" title="Collapse"> <i
          class="fas fa-minus"></i></button>
    </div>
  </div>
  <div class="card-body">
    <form id="transfer_form" name="transfer_form" action="" method="post" accept-charset="UTF-8"
      enctype="multipart/form-data">
      <div class="row">
        <div class="col-md-4 col-6">
          <div class="form-group">
            <label for="">Start Time</label>
            <input type="text" name="time_start" class="form-control datepicker" readonly autocomplete="off">
          </div>
        </div>
        <div class="col-md-4 col-6">
          <div class="form-group">
            <label for="">End Time</label>
            <input type="text" name="time_end" class="form-control datepicker" readonly autocomplete="off">
          </div>
        </div>
        <div class="col-md-4 col-4">
          <div class="form-group">
            <label for="">Discount / Promo code</label>
            <input type="text" name="promocode" class="form-control">
          </div>
        </div>
        <div class="col-md-3 col-6">
          <div class="form-group">
            <label for="">Discount Type</label>
            <select name="discount_type" class="form-control">
              <option value="">Select</option>
              <option value="services">Services</option>
              <option selected value="promocode">Promocode</option>
            </select>
          </div>
        </div>
        <div class="col-md-3 col-6">
          <div class="form-group">
            <label for="">Discount Code Type</label>
            <select name="discount_code_type" class="form-control">
              <option value="">Select</option>
              <option value="float">Float</option>
              <option value="percent">Percent (%)</option>
            </select>
          </div>
        </div>
        <div class="col-md-3 col-6">
          <div class="form-group">
            <label for="">Discount (if in percent (1-100))</label>
            <input type="text" name="discount" class="form-control">
          </div>
        </div>
        <div class="col-md-3 col-6">
          <div class="form-group">
            <label for="">Offer Image</label>
            <input type="file" name="offer_img" class="form-control-file">
          </div>
        </div>
      </div>
      <div class="row serviceDiv d-none">
        <div class="col-md-4 col-4">
          <div class="form-group">
            <label for="">Service</label>
            <select name="service_id" class="form-control">
              <option value="">Select</option>
              <?php foreach($services as $s) {?>
              <option value="<?php echo $s['id']?>"><?php echo $s['name']?></option>
              <?php }?>
            </select>
          </div>
        </div>
      </div>
      <div class="row">
        <div class="col-md-12">
          <div class="form-group">
            <input type="hidden" name="submit" value="true">
            <button type="submit" class="md-btn btn btn-primary btn-lg">Add</button>
          </div>
        </div>
      </div>
    </form>
  </div>
</div>
<?= view('admin/template_part/footer'); ?>
<script>
  $(document).ready(function (e) {
    $(document).on('change', 'select[name="discount_type"]', function(){
      if($(this).val()=='services') {
        $('.serviceDiv').removeClass('d-none');
      } else {
        $('.serviceDiv').addClass('d-none');
      }      
    });
  });
</script>
