<?= view('admin/template_part/header'); ?>
<?= view('admin/template_part/sidebar'); ?>
<!-- Main content -->
<style>
  .thumbnail {
    position: relative;
  }

  .removeImg {
    color: red;
    cursor: pointer;
    position: absolute;
    top: 5px;
    right: 5px;
  }

</style>
<div class="card">
  <div class="card-header">
    <h3 class="card-title"><?= $title;?></h3>
    <div class="card-tools">
      <button type="button" class="btn btn-tool" data-card-widget="collapse" data-toggle="tooltip" title="Collapse"> <i
          class="fas fa-minus"></i></button>
    </div>
  </div>
  <div class="card-body">
    <table id="defaultDatatables"
      class="table table-bordered table-condensed table-hover table-striped dt-responsive nowrap">
      <thead>
        <tr>
          <th>S.No</th>
          <th width="180">Action</th>
          <th>Start Time</th>
          <th>End Time</th>          
          <th>Discount Type</th>
          <th>Promocode</th>
          <th>Discount (Type of)</th>
          <th>Offer Image</th>
          <th>Service</th>
        </tr>
      </thead>
      <tbody>
        <?php $i = 1;foreach($list as $v) { ?>
        <tr>
          <td><?= $i;?></td>
          <td><button type="button" class="btn md-btn btn-primary" data-toggle="modal" data-id="<?= $v['id'];?>"
              data-stime="<?= $v['time_start'];?>" data-etime="<?= $v['time_end'];?>" data-dis="<?= $v['discount'];?>"
              data-img="<?= $v['image'];?>" data-serv="<?= $v['service_id'];?>" data-pc="<?= $v['discount_code'];?>" data-dt="<?= $v['type'];?>" data-dct="<?= $v['discount_code_type'];?>" data-target="#editModal">Edit</button>
            <a type="button" href="<?= base_url('admin/offers/remove/'.$v['id']);?>" onclick="return ConfirmDelete();"
              class="btn md-btn btn-danger">Remove</a></td>
          <td><?= $v['time_start'];?></td>
          <td><?= $v['time_end'];?></td>
          <td><?= ucfirst($v['type']);?></td>
          <td><?= $v['discount_code'];?></td>
          <td><?= $v['discount'];?> (<?= ucfirst($v['discount_code_type'])?>)</td>
          <td><?php if($v['image']!='') { ?><img src="<?= base_url('/public/assets/images/services/'.$v['image']);?>"
              width="180" /><?php } else { echo '-'; }?></td>
          <td><?= $v['service_id']!=0 ? getName('tbl_services', 'name', $v['service_id']) : '';?></td>
        </tr>
        <?php $i++;} ?>
      </tbody>
    </table>
  </div>
</div>
<div id="editModal" class="modal fade">
  <div class="modal-dialog modal-xl">
    <div class="modal-content bg-secondary">
      <div class="modal-header">
        <h4 class="modal-title">Update</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span></button>
      </div>
      <form role="form" method="post" action="" accept-charset="UTF-8" enctype="multipart/form-data">
        <div class="modal-body">
          <div class="row">
            <div class="col-md-12">
              <div class="my-box">
                <div class="row">
                  <div class="col-md-4 col-6">
                    <div class="form-group">
                      <label for="">Start Time</label>
                      <input type="text" name="time_start" class="form-control datepicker" readonly autocomplete="off">
                    </div>
                  </div>
                  <div class="col-md-4 col-6">
                    <div class="form-group">
                      <label for="">End Time</label>
                      <input type="text" name="time_end" class="form-control datepicker" readonly autocomplete="off">
                    </div>
                  </div>
                  <div class="col-md-4 col-4">
                    <div class="form-group">
                      <label for="">Discount / Promo code</label>
                      <input type="text" name="promocode" class="form-control">
                    </div>
                  </div>
                  <div class="col-md-3 col-6">
                    <div class="form-group">
                      <label for="">Discount Type</label>
                      <select name="discount_type" class="form-control">
                        <option value="">Select</option>
                        <option value="services">Services</option>
                        <option selected value="promocode">Promocode</option>
                      </select>
                    </div>
                  </div>
                  <div class="col-md-3 col-6">
                    <div class="form-group">
                      <label for="">Discount Code Type</label>
                      <select name="discount_code_type" class="form-control">
                        <option value="">Select</option>
                        <option value="float">Float</option>
                        <option value="percent">Percent (%)</option>
                      </select>
                    </div>
                  </div>
                  <div class="col-md-3 col-6">
                    <div class="form-group">
                      <label for="">Discount (if in percent (1-100))</label>
                      <input type="text" name="discount" class="form-control">
                    </div>
                  </div>
                  <div class="col-md-3 col-6">
                    <div class="form-group">
                      <label for="">Offer Image</label>
                      <input type="file" name="offer_img" class="form-control-file">
                    </div>
                  </div>
                </div>
                <div class="row serviceDiv d-none">
                  <div class="col-md-4 col-4">
                    <div class="form-group">
                      <label for="">Service</label>
                      <select name="service_id" class="form-control">
                        <option value="">Select</option>
                        <?php foreach($services as $s) {?>
                        <option value="<?php echo $s['id']?>"><?php echo $s['name']?></option>
                        <?php }?>
                      </select>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer justify-content-between">
          <input type="hidden" name="id" value="">
          <button type="button" class="btn btn-outline-light" data-dismiss="modal">Close</button>
          <button type="reset" class="btn btn-outline-light">Reset</button>
          <button type="submit" class="btn btn-outline-light">Save changes</button>
        </div>
      </form>
    </div>
  </div>
</div>
<?= view('admin/template_part/footer'); ?>
<script>
  $(document).ready(function (e) {
    $('#defaultDatatables').DataTable({
      "ordering": false,
      dom: 'lBfrtip',
      stateSave: true,
      initComplete: function () {
        var i = 0;
        this.api().columns().every(function () {
          var cls = '';
          if (i == 0 || i == 1 || i == 7) {
            cls = 'd-none';
          }
          var column = this;
          var select = $('<select class="form-control ' + cls +
              '" style="widppth:180px"><option value="">Search</option></select>')
            .appendTo($(column.header()))
            .on('change', function () {
              var val = $.fn.dataTable.util.escapeRegex(
                $(this).val()
              );
              column.search(val ? '^' + val + '$' : '', true, false).draw();
            });
          column.data().unique().sort().each(function (d, j) {
            select.append('<option value="' + d + '">' + d + '</option>');
          });
          i++;
        });
      },
      buttons: [
        'excel', 'pdf'
      ]
    });
    $('#editModal').on('shown.bs.modal', function (e) {
      $(this).find('input[name="id"]').val($(e.relatedTarget).data('id'));
      $(this).find('input[name="time_start"]').val($(e.relatedTarget).data('stime'));
      $(this).find('input[name="time_end"]').val($(e.relatedTarget).data('etime'));
      $(this).find('input[name="discount"]').val($(e.relatedTarget).data('dis'));
      $(this).find('select[name="service_id"]').val($(e.relatedTarget).data('serv'));
      $(this).find('input[name="promocode"]').val($(e.relatedTarget).data('pc'));
      $(this).find('select[name="discount_type"]').val($(e.relatedTarget).data('dt'));
      $(this).find('select[name="discount_code_type"]').val($(e.relatedTarget).data('dct'));
      if($(e.relatedTarget).data('dt')=='services') {
        $('.serviceDiv').removeClass('d-none');
      } else {
        $('.serviceDiv').addClass('d-none');
      }
      $(this).find('.modal-img').hide();
      if ($(e.relatedTarget).data('img') != '') {
        $(this).find('.modal-img').show();
        $(this).find('input[name="old_offer_img"]').val($(e.relatedTarget).data('img'));
        jQuery(this).find('.removeImg').attr('data-id', $(e.relatedTarget).data('id'));
        $(this).find('.img-thumbnail').prop('src', base_url + '/public/assets/images/services/' + $(e
          .relatedTarget).data('img'));
        jQuery(this).find('.removeImg').attr('data-img', $(e.relatedTarget).data('img'));
      }
    });
    $(document).on('change', 'select[name="discount_type"]', function(){
      if($(this).val()=='services') {
        $('.serviceDiv').removeClass('d-none');
      } else {
        $('.serviceDiv').addClass('d-none');
      }      
    });
  });
</script>
