<?= view('admin/template_part/header'); ?>
<?= view('admin/template_part/sidebar'); ?>
<div class="card">
  <div class="card-header">
    <h3 class="card-title"><?= $title;?></h3>
    <div class="card-tools">
      <button type="button" class="btn btn-tool" data-card-widget="collapse" data-toggle="tooltip" title="Collapse"> <i class="fas fa-minus"></i></button>
    </div>
  </div>
  <div class="card-body">
    <form id="transfer_form" name="transfer_form" action="" method="post" accept-charset="UTF-8" enctype="multipart/form-data">
      <div class="row">
        <div class="col-md-12">
          <div class="form-group">
            <label for="">Pathalogy Name</label>
            <input type="text" name="name" class="form-control" placeholder=" Enter Pathalogy name" required>
          </div>
        </div>
        <div class="col-md-12">
          <div class="form-group">
            <label for="">Image</label>
            <input type="file" name="path_image" class="form-control-file">
          </div>
        </div>
        <div class="col-md-12">
          <div class="form-group">
            <label for="">Description</label>
            <textarea name="description" class="form-control"></textarea>
          </div>
        </div>        
        <div class="col-md-6">
          <div class="form-group">
            <label for="">State</label>
            <select name="state" class="form-control">
              <option value="">Select</option>
              <?php foreach($state as $s) {?>
              <option value="<?php echo $s['id']?>"><?php echo $s['name']?></option>
              <?php }?>
            </select>
          </div>
        </div>
        <div class="col-md-6">
          <div class="form-group">
            <label for="">City</label>
            <select name="city" class="form-control">
            </select>
          </div>
        </div>
        <div class="col-md-12">
          <div class="form-group">
            <label for="">Address</label>
            <input type="text" name="address" class="form-control">
          </div>
        </div>
        <div class="col-md-6">
          <div class="form-group">
            <label for="">Latitude</label>
            <input type="text" name="lat" class="form-control">
          </div>
        </div>
        <div class="col-md-6">
          <div class="form-group">
            <label for="">Longitude</label>
            <input type="text" name="long" class="form-control">
          </div>
        </div>
        <div class="col-md-12">
            <div class="form-group">
              <input type="hidden" name="submit" value="true">
              <button type="submit" class="md-btn btn btn-primary btn-lg">Add</button>
            </div>
          </div>
      </div>
    </form>
  </div>
</div>
<?= view('admin/template_part/footer'); ?>
<script>
$(document).ready(function(e) {
	jQuery(document).on('change', 'select[name="state"]', function() {
		jQuery('select[name="city"]').empty();
		var formdata = new FormData();
		if(jQuery(this).val()=='') {
			return false;	
		}
		formdata.append('id', jQuery(this).val());
        $.ajax({
            url: base_url + 'admin/pathologies/getCityAjax',
            type: "POST",
            data: formdata,
            contentType: false,
            cache: false,
            processData: false,
            success: function(data) {
				jQuery.each(data, function(key, value) {
					jQuery('select[name="city"]').append('<option value="'+value.id+'">'+value.name+'</option>');
				});
            }
        });
	});
});      
</script>