<?= view('admin/template_part/header'); ?>
<?= view('admin/template_part/sidebar'); ?>
<style>
.thumbnail {
    position: relative;
}

.removeImg {
    color: red;
    cursor: pointer;
    position: absolute;
    top: 5px;
    right: 5px;
}
</style>
<div class="card">
  <div class="card-header">
    <h3 class="card-title"><?= $title;?></h3>
    <div class="card-tools">
      <button type="button" class="btn btn-tool" data-card-widget="collapse" data-toggle="tooltip" title="Collapse"> <i class="fas fa-minus"></i></button>
    </div>
  </div>
  <div class="card-body">
      <table id="defaultDatatables" class="table table-bordered table-condensed table-hover table-striped dt-responsive nowrap">
        <thead>
          <tr>
            <th>S.No</th>
            <th width="180">Action</th>
            <th>Pathology Name</th>
            <th>Image</th>
            <th>State</th>
            <th>City</th>
            <th>Description</th>
            <th>Address</th>
            <th>Latitude</th>
            <th>Longitude</th>
          </tr>
        </thead>
        <tbody>
          <?php $i = 1;foreach($list as $v) { ?>
          <tr>
            <td><?= $i;?></td>
            <td><button type="button" class="btn md-btn btn-primary" data-toggle="modal" data-id="<?= $v['id'];?>" 
              data-uname="<?= $v['name'];?>"
              data-state="<?= $v['state_id'];?>"
              data-city="<?= $v['city_id'];?>"
              data-img="<?= $v['image'];?>"
              data-desc="<?= $v['description'];?>"
              data-add="<?= $v['address'];?>"
              data-lat="<?= $v['latitude'];?>" 
              data-lng="<?= $v['longitude'];?>" data-target="#editModal">Edit</button>
              <a type="button" href="<?= base_url('admin/pathologies/remove/'.$v['id']);?>" onclick="return ConfirmDelete();" class="btn md-btn btn-danger">Remove</a></td>
            <td><?= $v['name'];?></td>
            <td><?php if($v['image']!='') {?><img src="<?= base_url();?>/public/assets/images/<?= $v['image'];?>"
            width="180" /><?php }?></td>
            <td><?= getName('master_state', 'name', $v['state_id']);?></td>
            <td><?= getName('master_city', 'name', $v['city_id']);?></td>
            <td><?= $v['description'];?></td>
            <td><?= $v['address'];?></td>
            <td><?= $v['latitude'];?></td>
            <td><?= $v['longitude'];?></td>
          </tr>
          <?php $i++;} ?>
        </tbody>
      </table>
</div>
    </div>
<div id="editModal" class="modal fade">
  <div class="modal-dialog modal-xl">
    <div class="modal-content bg-secondary">
      <div class="modal-header">
        <h4 class="modal-title">Update</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span></button>
      </div>
      <form role="form" method="post" action="" accept-charset="UTF-8" enctype="multipart/form-data">
        <div class="modal-body">
          <div class="row">
            <div class="col-md-12">
              <div class="my-box">
                <div class="row">
                  <div class="col-md-12">
                    <div class="form-group">
                      <label for="">Pathalogy Name</label>
                      <input type="text" name="name" class="form-control" placeholder=" Enter Pathalogy name" required>
                    </div>
                  </div>
                  <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="">Image <span class="danger">(leave blank if don't want
                                                    to update image)</span></label>
                                            <input type="file" name="path_image" class="form-control-file">
                                        </div>
                                        <div class="thumbnail modal-img"> <img class="img-thumbnail" src=""> <i
                                                class="far fa-times-circle fa-2x removeImg" data-id=""
                                                data-url="pathologies" data-img="" title="Remove this Image"></i>
                                            <input type="hidden" name="old_path_img">
                                        </div>
                                    </div>
                                    <div class="col-md-12">
          <div class="form-group">
            <label for="">Description</label>
            <textarea name="description" class="form-control"></textarea>
          </div>
        </div> 
                  <div class="col-md-6">
                    <div class="form-group">
                      <label for="">State</label>
                      <select name="state" class="form-control">
                        <option value="">Select</option>
                        <?php foreach($state as $s) {?>
                        <option value="<?= $s['id']?>"><?= $s['name']?></option>
                        <?php }?>
                      </select>
                    </div>
                  </div>

                  <div class="col-md-6">
                    <div class="form-group">
                      <label for="">City</label>
                      <select name="city" class="form-control">
                      </select>
                    </div>
                  </div>
                  <div class="col-md-12">
                    <div class="form-group">
                      <label for="">Address</label>
                      <input type="text" name="address" class="form-control">
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label for="">Latitude</label>
                      <input type="text" name="lat" class="form-control">
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label for="">Longitude</label>
                      <input type="text" name="long" class="form-control">
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer justify-content-between">
        	<input type="hidden" name="id" value="">
          <button type="button" class="btn btn-outline-light" data-dismiss="modal">Close</button>
          <button type="reset" class="btn btn-outline-light">Reset</button>
          <button type="submit" class="btn btn-outline-light">Save changes</button>
        </div>
      </form>
    </div>
  </div>
</div>
<?= view('admin/template_part/footer'); ?>
<script>
$(document).ready(function(e) {
	$('#defaultDatatables').DataTable({
        "ordering": false,
		dom: 'lBfrtip',
		stateSave: true,
		initComplete: function () {
            var i = 0;
            this.api().columns().every( function () {
                var cls = '';
                if(i==0 || i==1 || i==3) {
                    cls = 'd-none';
                }
                var column = this;
                var select = $('<select class="form-control '+cls+'" style="width:auto"><option value="">Search</option></select>')
                    .appendTo( $(column.header()))
                    .on( 'change', function () {
                        var val = $.fn.dataTable.util.escapeRegex(
                            $(this).val()
                        ); 
                        column.search( val ? '^'+val+'$' : '', true, false).draw();
                    }); 
                column.data().unique().sort().each( function ( d, j ) {
                    select.append( '<option value="'+d+'">'+d+'</option>');
                });
                i++;
            });
        },
		buttons: [
			'excel', 'pdf'
		]
  });
	$('#editModal').on('shown.bs.modal', function (e) {
		$(this).find('input[name="id"]').val($(e.relatedTarget).data('id'));
		$(this).find('input[name="name"]').val($(e.relatedTarget).data('uname'));
		$(this).find('select[name="state"]').val($(e.relatedTarget).data('state'));
		$(this).find('input[name="address"]').val($(e.relatedTarget).data('add'));
		$(this).find('input[name="lat"]').val($(e.relatedTarget).data('lat'));
		$(this).find('input[name="long"]').val($(e.relatedTarget).data('lng'));
    $(this).find('textarea[name="description"]').val($(e.relatedTarget).data('desc'));
		var formdata = new FormData();
		var that = this;
		formdata.append('id', $(e.relatedTarget).data('state'));
		$.ajax({
            url: base_url + 'admin/pathologies/getCityAjax',
            type: "POST",
            data: formdata,
            contentType: false,
            cache: false,
            processData: false,
            success: function(data) {
                jQuery.each(data, function(key, value) {
                  jQuery('select[name="city"]').append('<option value="'+value.id+'">'+value.name+'</option>');
                });
                $(that).find('select[name="city"]').val($(e.relatedTarget).data('city'));
            }
    });
    if ($(e.relatedTarget).data('img') != '') {
        $(this).find('.modal-img').show();
        $(this).find('input[name="old_path_img"]').val($(e.relatedTarget).data('img'));
        jQuery(this).find('.removeImg').attr('data-id', $(e.relatedTarget).data('id'));
        $(this).find('.img-thumbnail').prop('src', base_url + '/public/assets/images/' + $(e.relatedTarget).data('img'));
        jQuery(this).find('.removeImg').attr('data-img', $(e.relatedTarget).data('img'));
    } else {
        $(this).find('.modal-img').hide();
    }
	});
	
	jQuery(document).on('change', 'select[name="state"]', function() {
		jQuery('select[name="city"]').empty();
		var formdata = new FormData();
		if(jQuery(this).val()=='') {
			return false;	
		}
		formdata.append('id', jQuery(this).val());
        $.ajax({
            url: base_url + 'admin/pathologies/getCityAjax',
            type: "POST",
            data: formdata,
            contentType: false,
            cache: false,
            processData: false,
            success: function(data) {
				jQuery.each(data, function(key, value) {
					jQuery('select[name="city"]').append('<option value="'+value.id+'">'+value.name+'</option>');
				});
            }
        });
	});
});
</script>