<?= view('admin/template_part/header'); ?>
<?= view('admin/template_part/sidebar'); ?>
<!-- Main content -->
<div class="card">
  <div class="card-header">
    <h3 class="card-title"><?= $title;?></h3>
    <div class="card-tools">
      <button type="button" class="btn btn-tool" data-card-widget="collapse" data-toggle="tooltip" title="Collapse"> <i
          class="fas fa-minus"></i></button>
    </div>
  </div>
  <div class="card-body">
    <table id="defaultDatatables"
      class="table table-bordered table-condensed table-hover table-striped dt-responsive nowrap">
      <thead>
        <tr>
          <th>S.No</th>
          <th width="180">Action</th>
          <th>Username</th>
          <th>Password</th>          
          <th>Role</th>
          <th>Last Login</th>
          <th>Registered On</th>
        </tr>
      </thead>
      <tbody>
        <?php $i = 1;foreach($list as $v) { ?>
        <tr>
          <td><?= $i;?></td>
          <td><button type="button" class="btn md-btn btn-primary" data-toggle="modal" data-mytitle="Edit User" data-target="#addToModal">Edit</button>
          <div class="d-none addtocontent">
                    <form method="post" action="" class="row text-dark">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Username</label>
                                <input type="text" name="username" class="form-control" value="<?= $v['username']?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Role</label>
                                <select name="role" class="form-control" required>
                                  <option value="">Select</option>
                                  <option <?= $v['role']==1 ? 'selected' : '';?> value="1">Super Admin</option>
                                  <option <?= $v['role']==2 ? 'selected' : '';?> value="2">Editor</option>
                                </select>
                            </div>
                        </div>
                       <div class="col-12">
                            <div class="form-group">
                                <input type="hidden" name="id" value="<?= $v['id'];?>">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </form>
                </div>
            <?php if($v['role'] !=1) : ?><a type="button" href="<?= base_url('admin/admin-users/remove/'.$v['id']);?>" onclick="return ConfirmDelete();" class="btn md-btn btn-danger">Remove</a><?php endif;?></td>
          <td><?= $v['username'];?></td>
          <td> ******** <br> <button type="button" class="btn md-btn btn-primary" data-toggle="modal" data-mytitle="Change Password for <?= $v['username']?>" data-target="#addToModal">Change Password</button>
          <div class="d-none addtocontent">
                    <form method="post" action="<?= base_url('admin/admin-users/changePassword')?>" class="row text-dark">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Password</label>
                                <input type="text" name="password" class="form-control" value="">
                            </div>
                        </div>
                       <div class="col-12">
                            <div class="form-group">
                                <input type="hidden" name="id" value="<?= $v['id'];?>">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </form>
                </div></td>
          <td><?= $v['role']==1 ? 'Admin' : 'Editor';?></td>
          <td><?= date('d-m-Y h:ia', strtotime($v['last_login']));?></td>
          <td><?= date('d-m-Y h:ia', strtotime($v['registered_date']));?></td>
        </tr>
        <?php $i++;} ?>
      </tbody>
    </table>
  </div>
</div>
<?= view('admin/template_part/footer'); ?>
<script>
  $(document).ready(function (e) {
    $('#defaultDatatables').DataTable({
      "ordering": false,
      dom: 'lBfrtip',
      stateSave: true,
      initComplete: function () {
        var i = 0;
        this.api().columns().every(function () {
          var cls = '';
          if (i == 0 || i == 1 || i == 3 || i == 5 || i == 6) {
            cls = 'd-none';
          }
          var column = this;
          var select = $('<select class="form-control ' + cls +
              '" style="widppth:180px"><option value="">Search</option></select>')
            .appendTo($(column.header()))
            .on('change', function () {
              var val = $.fn.dataTable.util.escapeRegex(
                $(this).val()
              );
              column.search(val ? '^' + val + '$' : '', true, false).draw();
            });
          column.data().unique().sort().each(function (d, j) {
            select.append('<option value="' + d + '">' + d + '</option>');
          });
          i++;
        });
      },
      buttons: [
        'excel', 'pdf'
      ]
    });
  });
</script>
