<?= view('template/header'); ?>
<section class="outer-page-section cart_section pt-5 pb-3">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 offset-lg-1">
                <div class="cart_container">
                    <div class="cart_title">Shopping Cart</div>

                    <div class="cart-table my-5" tabindex="1" style="overflow: hidden; outline: none;">
                        <table>
                            <thead>
                                <tr>
                                    <th class="product-th">Test</th>
                                    <th>Price</th>
                                    <th>Quantity</th>
                                    <th class="total-th">Total</th>
                                    <th>Remove</th> 
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(!empty($items)) :
                                            foreach($items as $it) : 
                                            $image = $it['image']=='' ? base_url('/public/assets/images/lab-test.jpg') : base_url().'/public/assets/images/tests/'.$it['image'];?>
                                <tr class="cart-row" data-id="<?= $it['id']?>">
                                    <td class="product-col">
                                        <img class="rounded" src="<?= $image;?>" alt="">
                                        <div class="pc-title">
                                            <h4><?= $it['name'];?></h4>
                                            <p>Pathology: <?= $it['patho_name']?></p>
                                        </div>
                                    </td>
                                    <td class="price-col">Rs. <span class="cart-row-price"><?= $it['price'];?></span></td>
                                    <td class="quy-col">
                                        <div class="quy-input">
                                            <span>Qty</span>
                                            <input min="1" data-id="<?= $it['id'];?>" class="update-cart" type="number"
                                                value="<?= $it['quantity'];?>">
                                        </div>
                                    </td>
                                    <td class="total-col">Rs. <span class="cart-row-total"><?= $it['price'] * $it['quantity'];?></div></td>
                                    <td class="text-center"><button data-id="<?= $it['id'];?>" type="button"
                                            class="btn btn-dark shimmer remove-cart"><i class="fas fa-trash"></i></td>
                                </tr>
                                <?php endforeach;
                                        else :?>
                                <tr>
                                    <td colspan="4" class="">
                                        <h4 class="p-3">Cart is empty.</h4>
                                    </td>
                                </tr>
                                <?php endif;?>
                            </tbody>
                        </table>
                    </div>
                    <!-- Order Total -->
                    <div class="order_total">
                        <div class="order_total_content text-md-right">
                            <div class="order_total_title">Order Total:</div>
                            <div class="order_total_amount">Rs. <span class="cart-total"><?= $total?></span></div>
                        </div>
                    </div>
                    <div class="cart_buttons d-flex justify-content-between">
                        <a href="<?= base_url('/tests');?>" class="btn button cart_button_clear">Continue
                            Shopping</a>
                        <a href="<?= base_url('/checkout');?>" class="btn d-flex align-items-center btn-lg btn-dark">Proceed to checkout</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?= view('template/footer'); ?>