<?= view('template/header');
$disc = session()->get('discount'); ?>
<section class="outer-page-section cart_section pt-5 pb-3">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <form class="contact_form" action="#" method="post" novalidate="novalidate">
                    <div class="checkout-container">
                        <div class="cart_title mb-3">Checkout</div>
                        <div class="billing_details">
                            <div class="row">
                                <div class="col-lg-8">
                                    <h5 class="mb-2">Billing Details
                                        <div class="custom-control custom-checkbox float-right">
                                            <input type="checkbox" class="custom-control-input" checked
                                                name="saveAddress" id="saveAddress" value="1">
                                            <label class="custom-control-label" for="saveAddress">Save Address</label>
                                        </div>
                                    </h5>
                                    <div class="row">
                                        <div class="col-md-6 form-group">
                                            <label>Your Name</label>
                                            <input type="text" class="form-control" name="name"
                                                value="<?= @$user['name']?>">
                                        </div>
                                        <div class="col-md-6 form-group">
                                            <label>Mobile Number</label>
                                            <input type="text" class="form-control" name="mobile"
                                                value="<?= @$user['mobile']?>">
                                        </div>
                                        <div class="col-md-12 form-group">
                                            <label>Email</label>
                                            <input type="text" class="form-control" name="email"
                                                value="<?= @$user['email']?>">
                                        </div>
                                        <div class="col-md-12 form-group">
                                            <label>Address Line 1</label>
                                            <input type="text" class="form-control" name="address"
                                                value="<?= @$address['address']?>">
                                        </div>
                                        <div class="col-md-12 form-group">
                                            <label>Address Line 2</label>
                                            <input type="text" class="form-control" name="address2"
                                                value="<?= @$address['address2']?>">
                                        </div>
                                        <div class="col-md-6 form-group">
                                            <label>City</label>
                                            <input type="text" class="form-control" name="city"
                                                value="<?= @$address['city']?>">
                                        </div>
                                        <div class="col-md-6 form-group">
                                            <label>State</label>
                                            <input type="text" class="form-control" name="state"
                                                value="<?= @$address['state']?>">
                                        </div>
                                        <div class="col-md-6 form-group">
                                            <label>Country</label>
                                            <input type="text" class="form-control" name="country"
                                                value="<?= @$address['country']?>">
                                        </div>
                                        <div class="col-md-6 form-group">
                                            <label>Pincode</label>
                                            <input type="text" class="form-control" name="pincode"
                                                value="<?= @$address['pincode']?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="order_box">
                                        <h2>Your Order</h2>
                                        <ul class="list">
                                            <li>
                                                <h4>Product <span>Total</span> </h4>
                                            </li>
                                            <?php if(is_array($items)) :
                                            foreach($items as $it) :?>
                                            <li>
                                                <a target="_new"
                                                    href="<?=base_url();?>/tests/<?= slugify($it['name'])?>/<?= encode_url($it['id']);?>"><?= $it['name'];?>
                                                    <span class="middle">x <?= $it['quantity']?></span>
                                                    <span class="last">Rs. <?= $it['price']?></span>
                                                </a>
                                            </li>
                                            <?php endforeach;
                                            endif;?>
                                        </ul>
                                        <ul class="list list_2">
                                            <li class="discount_amount">
                                                <p class="mb-0">Discount <span>Rs.
                                                        <?= isset($disc['discountAmount']) && $disc['discountAmount']!='' ? $disc['discountAmount'] : 0; ?></span>
                                                </p>
                                            </li>
                                            <li class="order_total">
                                                <p>Order Total <span>Rs.
                                                        <?= isset($disc['finalAmount']) && $disc['finalAmount']!='' ? $disc['finalAmount'] : $total; ?></span>
                                                </p>
                                            </li>
                                        </ul>
                                        <ul class="list list_2">
                                            <li>
                                                <h4>Apply Promocode</h4>
                                            </li>
                                            <li class="promocode-applyer">
                                                <div class="input-group mb-1">
                                                    <input type="text" class="form-control"
                                                        placeholder="Enter Promo Code" <?= isset($disc['code']) && $disc['code']!='' ? 'readonly' : '';?> value="<?= isset($disc['code']) && $disc['code']!='' ? $disc['code'] : '';?>" aria-label="Enter Promo Code" aria-describedby="button-addon">
                                                    <div class="input-group-append">
                                                        <button <?= isset($disc['code']) && $disc['code']!='' ? 'disabled' : '';?> class="btn btn-secondary" type="button" id="button-addon"> Apply</button>
                                                    </div>
                                                </div>
                                                <div class="promocode-text mb-3">
                                                    <?php if(isset($disc['type']) && $disc['type']=='percent') : ?>
                                                    <p class="small text-muted">Promocode applied with <?= $disc['amount'];?>%  <a href="javascript:;" data-toggle="tooltip" title="Remove Applied Promocode" type="button" class="btn-link removeDiscount">Remove</a></p>
                                                    <?php elseif(isset($disc['type']) && $disc['type']=='float') :?>
                                                        <p class="small text-muted">Promocode applied with Flat Rs. <?= $disc['amount'];?>  <a href="javascript:;" data-toggle="tooltip" title="Remove Applied Promocode" type="button" class="btn-link removeDiscount">Remove</a></p>
                                                    <?php  else : ?>
                                                        <p class="small text-muted"></p>
                                                    <?php endif;?>
                                                </div>
                                            </li>
                                        </ul>
                                        <ul class="list list_2">
                                            <li>
                                                <div class="do-payment">
                                                    <h4 class="">Select Payment Method</h4>
                                                    <div class="custom-control custom-radio">
                                                        <input type="radio" id="payment_type2" checked
                                                            name="payment_type" class="custom-control-input"
                                                            value="Cash on delivery">
                                                        <label class="custom-control-label" for="payment_type2">Online
                                                            Payment</label>
                                                    </div>
                                                    <div class="custom-control custom-radio">
                                                        <input type="radio" id="payment_type" name="payment_type"
                                                            class="custom-control-input" value="Payment Gateway">
                                                        <label class="custom-control-label" for="payment_type">Cash on
                                                            delivery</label>
                                                    </div>
                                                    <div class="mt-3">
                                                        <button type="submit"
                                                            class="btn btn-outline-dark btn-large btn-block">Buy
                                                            Now</button>
                                                    </div>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>
<?= view('template/footer'); ?>
