<?= view('template/header'); ?>
<section id="banner" class="d-flex align-items-center">
    <div class="container home-container">
        <div class="banner_heading">
            <h4>#GharSeLabTest</h4>
            <h2>Book The Lab Test<br />
                From Your Home Online<br />
                And Get Test Report at Door Step </h2>
        </div>
    </div>
</section>
<section id="why-us" class="why-us">
      <div class="container">
        <div class="row">
          <div class="col-lg-4 d-flex align-items-stretch">
            <div class="content">
              <h3>Why Choose Medicoserve Services?</h3>
              <p>
                Medicoserve has bought Pathlabs, Doctors, Pharmacist & Cousvers on single platform.
              </p>
            </div>
          </div>
          <div class="col-lg-8 d-flex align-items-stretch">
            <div class="icon-boxes d-flex flex-column justify-content-center">
              <div class="row">
                <div class="col-xl-4 d-flex align-items-stretch">
                  <div class="icon-box mt-4 mt-xl-0">
                    <i class="fas fa-vial fa-lg" aria-hidden="true"></i>
                    <h4>Labs</h4>
                    <p>Book free collection of samples from home for laboratory tests.</p>
                  </div>
                </div>
                <div class="col-xl-4 d-flex align-items-stretch">
                  <div class="icon-box mt-4 mt-xl-0">
                    <i class="fas fa-user-md fa-lg" aria-hidden="true"></i>
                    <h4>Doctor Consultation</h4>
                    <p>Consult a doctor from comfort of your house.</p>
                  </div>
                </div>
                <div class="col-xl-4 d-flex align-items-stretch">
                  <div class="icon-box mt-4 mt-xl-0">
                    <i class="far fa-hospital fa-lg"></i>
                    <h4>Hospital Procedures</h4>
                    <p>Book hospital of your choice, for any procedure at affordable prices.</p>
                  </div>
                </div>
              </div>
            </div><!-- End .content-->
          </div>
        </div>
      </div>
    </section>
<section id="main">
    <div class="container home-container">
        <div class="main_section">
            <div class="row">
                <div class="col">
                    <div class="card shadow p-3 mb-5 mx-lg-5">
                        <div class="media service-media">
                          <i class="fas fa-ambulance fa-3x mr-3"></i>
                          <div class="media-body">
                            <h5 class="mt-0">Ambulance Services</h5>
                            Difficulty in reaching hospital. We are jus one call away.
                          </div>
                        </div>
                    </div>
                </div>
            </div>
            <div id="row1" class="social-box">
                <div class="heading">
                    <h2>Lab Test From The Comfort Of Your Home</h2>
                    <p>15,00,000+ lab tests booked | 4,00,000+ satisfied customers</p>
                </div>
                <div class="row">
                    <div class="col-lg-2 col-xs-12 text-center">
                        <div class="box">
                            <i class="fas fa-medkit fa-3x" aria-hidden="true"></i>
                            <div class="box-title">
                                <h3>100% Safe & Hygenic</h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-2 col-xs-12 text-center">
                        <div class="box">
                            <i class="fas fa-vial fa-3x" aria-hidden="true"></i>
                            <div class="box-title">
                                <h3>Home Sample Pick Up</h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-2 col-xs-12 text-center">
                        <div class="box">
                            <i class="fas fa-door-open fa-3x" aria-hidden="true"></i>
                            <div class="box-title">
                                <h3>Door Step Delivery</h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-2 col-xs-12 text-center">
                        <div class="box">
                            <i class="fas fa-file-medical-alt fa-3x" aria-hidden="true"></i>
                            <div class="box-title">
                                <h3>View Reports Online</h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-2 col-xs-12 text-center">
                        <div class="box">
                            <i class="fas fa-user-md fa-3x" aria-hidden="true"></i>
                            <div class="box-title">
                                <h3>Free Doctor Consultation</h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-2 col-xs-12 text-center">
                        <div class="box">
                            <i class="fas fa-tag fa-3x" aria-hidden="true"></i>
                            <div class="box-title">
                                <h3>Best Prices Guaranteed</h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div id="row2">
                <div class="heading">
                    <h2>Top Labs</h2>
                    <p>Featured labs</p>
                    <button class="see_more">
                        <a href="<?=base_url();?>/labs">See More</a>
                    </button>
                </div>
                <div class="labs-slider owl-carousel  owl-theme">
                    <?php if (!empty($pathologies)) {
                    foreach ($pathologies as $p) { ?>
                    <div class="slide2_item"> <a
                            href="#">
                            <div class="hovereffect"> <img class="img-fluid"
                                    src="<?= base_url();?>/public/assets/images/<?=$p['image']?>">
                            </div>
                        </a> <a href="#">
                            <h4><?= $p['name']?>
                            </h4>
                        </a>
                    </div>
                    <?php } }?>
                </div>
            </div>
            <!--end of row2-->

            <div id="row3">
                <div class="row">
                    <div class="col-md-6">
                        <div class="row3_item"> <a href="<?=base_url();?>/doctors" rel="nofollow">
                                <div class="hovereffect"><img class="img-fluid"
                                        src="<?= base_url();?>/public/assets/images/new-doctor-banner-Desktop-1024x604-1024x604.jpg"
                                        title="Doctors" alt="Doctors" /></div>
                            </a>
                            <h3>2500+ <span>Doctors</span></h3>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="row3_item"> <a href="<?=base_url();?>/hospitals" rel="nofollow">
                                <div class="hovereffect"><img class="img-fluid"
                                        src="<?= base_url();?>/public/assets/images/hospitals.png"
                                        title="Hospitals" alt="Hospitals" /></div>
                            </a>
                            <h3>500+ <span>Hospitals</span></h3>
                        </div>
                    </div>
                </div>
            </div>
            <!-- end or row3-->

            <div id="row4">
                <div class="heading">
                    <h2>Availabel Tests</h2>
                    <p>&nbsp;</p>
                    <button class="see_more">
                        <a href="<?=base_url();?>/tests">See
                            More</a>
                    </button>
                </div>
                <div class="labs-slider owl-carousel  owl-theme">
                    <?php if (!empty($tests)) {
                        foreach ($tests as $t) {
                        $image = $t['image']=='' ? base_url('/public/assets/images/lab-test.jpg') : base_url().'/public/assets/images/tests/'.$t['image'];?>
                    <div class="slide2_item"> <a
                            href="<?=base_url();?>/tests/<?= slugify($t['name'])?>/<?= encode_url($t['id']);?>">
                            <div class="hovereffect">
                                <img class="img-fluid" src="<?=$image; ?>">
                            </div>
                        </a> <a href="<?=base_url();?>/tests/<?= slugify($t['name'])?>/<?= encode_url($t['id']);?>">
                            <h4><?= $t['name'];?>  <?= $t['price'] != '' ? '<span class="price-tag">Starting at Rs. '.$t['price'].'</span>' : ''; ?></h4>
                        </a>
                    </div>
                    <?php } }?>
                </div>
            </div>

            <div id="row6">
                <div class="heading">
                    <h2>Medshots</h2>
                    <p>A shot of good health. For a healthier you.</p>
                    <button class="see_more">
                        <a href="<?=base_url();?>/blog/" rel="nofollow">See More</a>
                    </button>
                </div>
                <div id="slider5" class="carousel slide" data-ride="carousel">
                    <div class="carousel-inner">
                        <div class="carousel-item  active ">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="row6_item"> <a
                                            href="#"
                                            rel="nofollow"
                                            title="Pain In The Joints: 8 Possible Causes & What To Do About Them"
                                            alt="Pain In The Joints: 8 Possible Causes & What To Do About Them">
                                            <div class="hovereffect"><img class="img-fluid"
                                                    src="<?= base_url();?>/public/assets/images/ezgif.com-gif-maker-26-768x480.jpg"
                                                    title="Pain In The Joints: 8 Possible Causes & What To Do About Them"
                                                    alt="Pain In The Joints: 8 Possible Causes & What To Do About Them" />
                                            </div>
                                        </a>
                                        <p>Pain In The Joints: 8 Possible Causes & What To Do About Them</p>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="row6_item"> <a
                                            href="#"
                                            rel="nofollow" title="Does Cutting Sugar Out Of Your Diet Prevent Diabetes?"
                                            alt="Does Cutting Sugar Out Of Your Diet Prevent Diabetes?">
                                            <div class="hovereffect"><img class="img-fluid"
                                                    src="<?= base_url();?>/public/assets/images/ezgif.com-gif-maker-24-768x480.jpg"
                                                    title="Does Cutting Sugar Out Of Your Diet Prevent Diabetes?"
                                                    alt="Does Cutting Sugar Out Of Your Diet Prevent Diabetes?" /></div>
                                        </a>
                                        <p>Does Cutting Sugar Out Of Your Diet Prevent Diabetes?</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="carousel-item ">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="row6_item"> <a
                                            href="#"
                                            rel="nofollow"
                                            title="Work-Related Anxiety & Panic Attacks? 3 Things To Keep In Mind"
                                            alt="Work-Related Anxiety & Panic Attacks? 3 Things To Keep In Mind">
                                            <div class="hovereffect"><img class="img-fluid"
                                                    src="<?= base_url();?>/public/assets/images/ezgif.com-gif-maker-23-768x480.jpg"
                                                    title="Work-Related Anxiety & Panic Attacks? 3 Things To Keep In Mind"
                                                    alt="Work-Related Anxiety & Panic Attacks? 3 Things To Keep In Mind" />
                                            </div>
                                        </a>
                                        <p>Work-Related Anxiety & Panic Attacks? 3 Things To Keep In Mind</p>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="row6_item"> <a
                                            href="#"
                                            rel="nofollow"
                                            title="Heroes With Stethoscope: An Ode To Doctors Braving The Pandemic"
                                            alt="Heroes With Stethoscope: An Ode To Doctors Braving The Pandemic">
                                            <div class="hovereffect"><img class="img-fluid"
                                                    src="<?= base_url();?>/public/assets/images/NDD-768x480.jpg"
                                                    title="Heroes With Stethoscope: An Ode To Doctors Braving The Pandemic"
                                                    alt="Heroes With Stethoscope: An Ode To Doctors Braving The Pandemic" />
                                            </div>
                                        </a>
                                        <p>Heroes With Stethoscope: An Ode To Doctors Braving The Pandemic</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="carousel-item ">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="row6_item"> <a
                                            href="#"
                                            rel="nofollow" title="6 Ways To Reduce Your Risk Of Developing Cataracts"
                                            alt="6 Ways To Reduce Your Risk Of Developing Cataracts">
                                            <div class="hovereffect"><img class="img-fluid"
                                                    src="<?= base_url();?>/public/assets/images/ezgif.com-gif-maker-17-768x480.jpg"
                                                    title="6 Ways To Reduce Your Risk Of Developing Cataracts"
                                                    alt="6 Ways To Reduce Your Risk Of Developing Cataracts" /></div>
                                        </a>
                                        <p>6 Ways To Reduce Your Risk Of Developing Cataracts</p>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="row6_item"> <a
                                            href="#"
                                            rel="nofollow"
                                            title="Vitiligo: Fighting The Stigma Around This Skin Condition"
                                            alt="Vitiligo: Fighting The Stigma Around This Skin Condition">
                                            <div class="hovereffect"><img class="img-fluid"
                                                    src="<?= base_url();?>/public/assets/images/ezgif.com-gif-maker-16-768x480.jpg"
                                                    title="Vitiligo: Fighting The Stigma Around This Skin Condition"
                                                    alt="Vitiligo: Fighting The Stigma Around This Skin Condition" />
                                            </div>
                                        </a>
                                        <p>Vitiligo: Fighting The Stigma Around This Skin Condition</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <a class="carousel-control-prev" href="#slider5" role="button" data-slide="prev"> <img
                            src="data:image/png;base64,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"
                            title="Previous" alt="Previous"> <span class="sr-only">Previous</span> </a> <a
                        class="carousel-control-next" href="#slider5" role="button" data-slide="next"> <img
                            src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFwAAABcCAYAAADj79JYAAAHa0lEQVR4nO2dz2sTTRjHx/eXml6l8IIgKHgUPAleBME/oBQ8eeiheBORgPJS0NyEoJdeSi+9GHhPaS/9AwShNoSyBITGN1iEyXtsqMlulkz7zLyHdxOn05nZ3WRnd7bdL8zJtrv7ma/PPDM78yxChQoVSleXEmyFJIoD8BdJKzogguJCnbZdePhRAf+aQIvaAedOUZ3Mw/pN037nmu7ndPDPreunhcxD/SNGU3VGHPi5lA60DLIK8GVJu8I12b+HdYAKfi7B60KHCrQMMA/1aowm6wyxA3TgcxVmoriad7MMMg+vFLS5GG38O2IniPB51+fS7WGuFh0tgzwBXKlU5jHGC4eHh2Xf9zcIITuEEAcAMOMEAJgQ4hBCdnzf3zg8PCxjjBcqlco8kneACF/meOuh61wtCx086AnkVqt1z3Xdt4SQTywBEUI+ua77ttVq3UNn4Y/Bq0KNyu2ZK8zVfPgQQc/VarXrg8FgBQC+JAFZJQD4MhgMVmq12nX0E74IXhdmrIAeBbYUdL1ev+F53iql1DUJWhSl1PU8b7Ver99AevDWQVfBlsXqCexyuXzNdd0qY2yYJmiJhq7rVsvl8jWkhy6GmEygx4VdQgjNdbvdxwDwPWPQpwQA37vd7mP00+3WQQ+DLXW17/sbWcPVyff9DY3bM4MeG/bu7u4dAGhlDTSKAODL7u7uHVugx4bdbrcfUkp7WYOMI0ppr91uP7QBughczEZ42HMY40WW/cA4rYYY40X0f1znocuyFyPAde4eD5ATZ3e73ceMsZOsqc2ok2Aw5Z0upozGXB4G+/IYdqfTecDy62xRw06n84CDLsvTReiJweZDiTT1azabd/MWs8NEKe01m827SJ0yJhpawkLJBHa5XL6Wl2wkrgCgxaWMsnieWGiJGrfnbM+zZ5Xv+xvo9CBqJLSospJTcTvISM69gsxFjOeqrGUm2Cp3lyqVyjwAfMsaRhoCgG/BOnvU0DI18HEPilnJXL/ff2/i4TqdDnvx4gVbXl5ma2trzPd9E5eJrX6//x79DC38ADqTy3WZyWSg3N7evskMpYArKyvsyZMnk/bmzRvmeZ6JS8XVcHt7+2aIy2MPnqpwcsrdnuetmnqqp0+fngJuE3TP81YlLp8prOjy7isIoVKtVrtu8uXBhw8fzgC3BTql1A3eHI1drsvLE3F3qdfr/WXyoY6Pj1m1WrUW+mAweI3UGUssl0caLNOY5IxGI2uhA8A3JM/LYw+eoeHEcZz7aT2YzdC5dZaZwoouO7mKECqZSgVVsjW8BCmiLqyEAo+UnRBCdtJ+OBuhE0J20IzZSlg4uVqpVOZZRmvdFkI/CWaeuvWVmYCXMMYLaT8VL9ugY4wXULRJUCzgk9nlYDBYSfWJJDo+Pmbv3r2zAjqXHiYG/FT8tmUZ1hbow+Hwb6SP47MBT2qjZRIKgz4ajYzfQ4SBczbgAPCP8aeIIR30tbU149cXJkBTAdemhJTSf40/RUyNRiP2/PlzKXTTy7qU0p4E+HjGyaeGkYCfeZVGKf1h9Amm0OfPn6Wwnz17xgDA9OVPkHqKPztw03cfV41Ggy0tLZ2BvbS0xL5+/ZrKPRgFbpPDm82mEvbe3l5at5Gow62N4ZbATiSGW5+l2AKbsWSyFKvzcJtgM5ZCHp7lTNM22IyZmWlasZayt7dnHWzGzKylZL5aaCtsxsytFma2Hm4zbMbYyfr6+p8oofVw3cDZSONpLIfNCCENlMD+FCveae7v71sNm7Fk3mnqgKf61v7Vq1dWw2bM3Ft76RTf9Nl4caubbbBN7UtR7rwynR7W6/UJ7OXlZdZq2XW4IsmdVzKXnwkr9Xr9hunCBI7jsI8fP7Jez65jQ5RSNyiOkMjewqguN7p71maZ3D2rnXVubW3dYoyZf3Fol0ZbW1u3UML7w0WXp34CwlaZOgEhAle6PDjjg8NvNf8CAGzyjI8IvTjFZvgUmwi8OKeZ4jnN0NASnETezxqMCQHAflonkWXQw87aW/OSOQlRSn9wZ+11BQ4SgS1CV4WWSTxvt9sP2TmqJiEUq0mlmgQPPEo8L+qlGIKurQgUQM+r04dcpbdMKgLJgPMul9a8Ojg4eJS3+imU0t7BwcEjZEHNq6mgN5vNu3nJXgBgXxgg81lKr6hbaB66rjKnVcsAAICFypyybCSX5VAnbg8WvLJeZRz1+/33eak9O5YKumpyNKmuvLm5eTvL6sqbm5u3Uc6qK48VBbot9cNf571++Fgy6LoQI62Q7zjOfdd1q0nteyGENFzXrTqOcx+pK+SHhRDrYI91CYW7XQf+FPz19fU/McaLR0dHL4NvQDQIIY6Y11NKe8E3IBq+728cHR29xBgvBjuizu03IMZSQdeFGT7UmPzKieybD7n+yslY4o3K3C5zPA+/+I7PFIridhF88aWqBKQDr4Kv64CwJgOsg3xuQPOS/TfVuV6ELzYVVLGJf1MH+dzAFhUGXtUB0zTZ370QkGVSOUzVAdM23XUurHRQonRGnN8vJFEcgAXgQoUKXWT9B6yz5n0GtDnZAAAAAElFTkSuQmCC"
                            title="Next" alt="Next"> <span class="sr-only">Next</span> </a>
                </div>
            </div>
            <!-- end or row6-->

        </div>
        <!--end of main_section-->
    </div>
    <!--end of container-->
</section>
<!--end of main -->
<div id="section2">
    <div class="sec2_inner">
        <div class="sec2_1">
            <div class="ratsec">
                <div class="ratleft"> <img src="<?= base_url();?>/public/assets/images/smilerat.png"
                        title="50000+ 5 star ratings" alt="50000+ 5 star ratings"> </div>
                <div class="ratright">
                    <h3>50000+</h3>
                    <p>5 star ratings</p>
                </div>
            </div>
            <div class="ratsec">
                <div class="ratleft"> <a
                        href="#"><img
                            src="<?= base_url();?>/public/assets/images/downloadrat.png"
                            title="2 Million Downloads" alt="2 Million Downloads"></a> </div>
                <div class="ratright">
                    <h3 class="million">2 Million+</h3>
                    <p>Downloads</p>
                </div>
            </div>
            <button class="shimmer">
                <a href="#">Download Medicoserve
                    App</a>
            </button>
        </div>
        <div class="sec2_2">
            <div class="sec2_item">
                <p class="sec2_txt1"><span>Harshit Shukla</span> <img
                        src="<?=base_url();?>/public/assets/images/star.png" title="Rating"
                        alt="Rating"><img src="<?=base_url();?>/public/assets/images/star.png"
                        title="Rating" alt="Rating"><img
                        src="<?=base_url();?>/public/assets/images/star.png" title="Rating"
                        alt="Rating"><img src="<?=base_url();?>/public/assets/images/star.png"
                        title="Rating" alt="Rating"><img
                        src="<?=base_url();?>/public/assets/images/star.png" title="Rating" alt="Rating">
                </p>
                <p class="sec2_txt2">Very convenient and useful. I wanted some tests run for my parents who were staying
                    with me .Since I couldnt travel with them to the lab, I tried using this after hearing an ad. A lab
                    person came home and took the blood samples. I got both their reports on my app and doctors were
                    also assigned for us.</p>
            </div>
            <div class="sec2_item">
                <p class="sec2_txt1"><span>Sanya Kaushik</span> <img
                        src="<?=base_url();?>/public/assets/images/star.png" title="Rating"
                        alt="Rating"><img src="<?=base_url();?>/public/assets/images/star.png"
                        title="Rating" alt="Rating"><img
                        src="<?=base_url();?>/public/assets/images/star.png" title="Rating"
                        alt="Rating"><img src="<?=base_url();?>/public/assets/images/star.png"
                        title="Rating" alt="Rating"><img
                        src="<?=base_url();?>/public/assets/images/star.png" title="Rating" alt="Rating">
                </p>
                <p class="sec2_txt2">I was freaking out about a personal issue, but I was at work and couldn't really
                    get out and talk to a doc. A friend of mine recommended this app and 5 mins later, I was speaking
                    with one of the most reputed gynaecologists in Bangalore. I don't usually rely on apps for health
                    stuff, but medicoserve exceeded my expectations. Thanks, guys!</p>
            </div>
        </div>
        <div class="sec2_3">
            <div class="sec2_item">
                <p class="sec2_txt1"><span>Vidyadhar M</span> <img
                        src="<?=base_url();?>/public/assets/images/star.png" title="Rating"
                        alt="Rating"><img src="<?=base_url();?>/public/assets/images/star.png"
                        title="Rating" alt="Rating"><img
                        src="<?=base_url();?>/public/assets/images/star.png" title="Rating"
                        alt="Rating"><img src="<?=base_url();?>/public/assets/images/star.png"
                        title="Rating" alt="Rating"><img
                        src="<?=base_url();?>/public/assets/images/star.png" title="Rating" alt="Rating">
                </p>
                <p class="sec2_txt2">This app is really flawless. Good for elderly people. Best part of the app is home
                    delivery of medicine at discounted price.</p>
            </div>
            <div class="sec2_item">
                <p class="sec2_txt1"><span>Mona Gandhi</span> <img
                        src="<?=base_url();?>/public/assets/images/star.png" title="Rating"
                        alt="Rating"><img src="<?=base_url();?>/public/assets/images/star.png"
                        title="Rating" alt="Rating"><img
                        src="<?=base_url();?>/public/assets/images/star.png" title="Rating"
                        alt="Rating"><img src="<?=base_url();?>/public/assets/images/star.png"
                        title="Rating" alt="Rating"><img
                        src="<?=base_url();?>/public/assets/images/star.png" title="Rating" alt="Rating">
                </p>
                <p class="sec2_txt2">The app is great! I consulted for my father and the doctor was nice and he
                    explained in detail. I need not take a half day off from office, could speak to the doctor very
                    fast.</p>
            </div>
            <div class="sec2_item">
                <p class="sec2_txt1"><span>Minlun Vaiphei</span> <img
                        src="<?=base_url();?>/public/assets/images/star.png" title="Rating"
                        alt="Rating"><img src="<?=base_url();?>/public/assets/images/star.png"
                        title="Rating" alt="Rating"><img
                        src="<?=base_url();?>/public/assets/images/star.png" title="Rating"
                        alt="Rating"><img src="<?=base_url();?>/public/assets/images/star.png"
                        title="Rating" alt="Rating"><img
                        src="<?=base_url();?>/public/assets/images/star.png" title="Rating" alt="Rating">
                </p>
                <p class="sec2_txt2">I am glad that an app like this is created for the benefit of all. It would really
                    be a game changer in healthcare ecosystem in India. I hope medicoserve app stays true to people's
                    expectations. I am to go for 5-star ratings.</p>
            </div>
        </div>
    </div>
    <!--end of section 2 inner -->
</div>
<!--end of section2-->
<?= view('template/footer');
