<?= view('template/header'); 
$image = $test['image']=='' ? base_url('/public/assets/images/lab-test.jpg') : base_url().'/public/assets/images/tests/'.$test['image'];?>
<section class="outer-page-section pt-5 pb-3">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="p-4 card shadow">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="test-img text-center">
                                <img src="<?= $image;?>"
                                    class="img-fluid">
                            </div>
                        </div>
                        <div class="col-md-8">
                            <div class="test-title">
                                <h3><?=ucfirst($test['name'])?></h3>
                            </div>
                            <div class="test-service">
                                <p><?= $test['service_name']?></p>
                            </div>
                            <div class="test-description">
                                <p><?= $test['description']?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 pathlist">
                <div class="card card-nav-tabs card-plain mt-5">
                    <div class="card-header card-header-danger">
                        <!-- colors: "header-primary", "header-info", "header-success", "header-warning", "header-danger" -->
                        <div class="nav-tabs-navigation">
                            <div class="nav-tabs-wrapper">
                                <ul class="nav nav-tabs" data-tabs="tabs">
                                    <li class="nav-item">
                                        <h3 class="text-light">Select Pathology Lab</h3>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="card-body ">
                        <?php foreach ($path as $key => $p) : ?>
                        <div class="card mb-2 shadow">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="hovereffect text-center">
                                            <img class="img-fluid"
                                                src="<?= base_url();?>/public/assets/images/<?=$p['image']?>">
                                        </div>
                                    </div>
                                    <div class="col-md-9">
                                        <h4 class="card-title"><?= ucfirst($p['pathname']);?></h4>
                                        <p class="card-text desc-text"><?= $p['description']?></p>
                                        <p class="cart-text addr-text"><i class="fa fa-map-marker"
                                                aria-hidden="true"></i>
                                            <?= $p['address'].', '.$p['city_name'].', '.$p['state_name']?></p>
                                        <div class="price-selector">
                                            <div class="frb frb-success mr-2">
                                                <input type="radio" <?= $key==0 ? 'checked' : '';?>
                                                    id="medico_offer<?= $key;?>" name="price_selected"
                                                    value="<?= $p['medicooffer'];?>">
                                                <label for="medico_offer<?= $key;?>">
                                                    <div class="frb-title">Rs. <?= $p['medicooffer'];?></div>
                                                    <div class="frb-description">Medico Offer Price</div>
                                                </label>
                                            </div>
                                            <div class="add-to-cart-btn">
                                                <button type="button" data-goto="<?= base_url();?>/cart"
                                                    data-testid="<?= $test['id']?>" data-tbpid="<?= $p['id']?>"
                                                    <?= $key==0 ? '' : 'disabled';?>
                                                    class="btn btn-lg btn-dark shimmer add-to-cart">Book Now</button>
                                            </div>
                                        </div>
                                        <!--<p class="mb-0">Original Price: Rs. <?= $p['orgprice'];?></p>-->
                                        <p class="mb-0">MRP: Rs. <?= $p['mrp'];?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach;?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?= view('template/footer'); ?>
