<!doctype html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="stylesheet" href="//stackpath.bootstrapcdn.com/bootstrap/4.5.0/css/bootstrap.min.css" integrity="sha384-9aIt2nRpC12Uk9gS9baDl411NQApFmC26EwAOH8WgZl5MYYxFfc+NcPb1dKGj7Sk" crossorigin="anonymous">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.12.0/themes/smoothness/jquery-ui.css" crossorigin="anonymous">
    <link rel="stylesheet" href="//use.fontawesome.com/releases/v5.3.1/css/all.css" integrity="sha384-mzrmE5qonljUremFsqc01SB46JvROS7bZs3IO2EmfFsd15uHvIt+Y8vEf7N7fWAU" crossorigin="anonymous">
    <link rel="stylesheet" type="text/css" href="<?= base_url('public/assets');?>/owl/dist/assets/owl.carousel.min.css">
    <link rel="stylesheet" type="text/css" href="<?= base_url('public/assets');?>/owl/dist/assets/owl.theme.default.min.css">
    <link rel="stylesheet" type="text/css" href="<?= base_url('public/assets');?>/style.css">
    <title><?= isset($title) ? $title : '';?></title>
    <meta name="description" content="" />
    <link rel="canonical" href="<?= site_url();?>" />
    <meta property="og:locale" content="en_US" />
    <meta property="og:type" content="website" />
    <meta property="og:title" content="Medicoserve" />
    <meta property="og:description" content="" />
  </head>

  <body>
    <a href="JavaScript:void(0);" id="scrolltop" style="display: none;"><i class="fas fa-level-up-alt"></i></a>
    <div class="loader"></div>
    <nav class="header fixed-top navbar navbar-expand-lg navbar-light shadow">
      <div class="container">
        <a class="navbar-brand" href="<?= site_url();?>">Medicoserve</a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNavAltMarkup"
          aria-controls="navbarNavAltMarkup" aria-expanded="false" aria-label="Toggle navigation">
          <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNavAltMarkup">
          <ul class="navbar-nav ml-auto">
            <li class="nav-item"><a class="nav-link" href="#">Diagnostic</a></li>
            <li class="nav-item"><a class="nav-link" href="#">Lab tests</a></li>
            <li class="nav-item"><a class="nav-link" href="<?=base_url('/about-us')?>">About us</a></li>
            <li class="nav-item"><a class="nav-link" href="#">Contact us</a></li>
            <?php if(session()->get('logged_user')) : ?>
            <li class="nav-item"><a class="nav-link" href="<?= base_url()?>/my-account">Account</a></li>
            <li class="nav-item"><a class="nav-link" href="<?= base_url()?>/logout">Logout</a></li>
            <?php else :?>
            <li class="dropdown nav-item"><a href="#" data-toggle="dropdown" class="dropdown-toggle nav-link">Login</a>
              <div class="dropdown-menu action-form">
                <form id="sign-in-form" action="" method="post">
                  <p class="hint-text">Please login to continue..</p>
                  <div class="form-group">
                    <input type="text" name="mobile" class="form-control" placeholder="Mobile No." required="required">
                  </div>
                  <div class="form-group otpdiv d-none">
                    <input type="text" class="form-control" name="otp" placeholder="OTP" required="required">
                  </div>
                  <button type="submit" class="btn btn-primary btn-block sign-in">Send OTP</button>
                </form>
              </div>
            </li>
            <li class="dropdown nav-item"><a href="#" data-toggle="dropdown" class="dropdown-toggle nav-link">Signup</a>
              <div class="dropdown-menu action-form">
                <form id="sign-up-form" action="" method="post">
                  <p class="hint-text">Fill in this form to create your account!</p>
                  <div class="form-group">
                    <input type="text" name="name" class="form-control" placeholder="Your Name" required="required">
                  </div>
                  <div class="form-group">
                    <input type="text" name="mobile" class="form-control" placeholder="Mobile No.">
                  </div>
                  <div class="form-group otpdiv d-none">
                    <input type="text" name="otp" class="form-control" placeholder="Otp" required="required">
                  </div>
                  <div class="form-group">
                    <label class="form-check-label"><input name="terms" type="checkbox" required> I accept the
                      <a href="#">Terms & Conditions</a></label>
                  </div>
                  <button type="submit" class="btn btn-primary btn-block sign-up">Send OTP</button>
                </form>
              </div>
            </li>
            <?php endif;?>
            <div class="cart-dropdown dropdown">
              <?php $cart = getCartItems();?>
              <button type="button" class="btn btn-dark" data-toggle="dropdown">
                <i class="fa fa-shopping-cart" aria-hidden="true"></i> Cart <span
                  class="badge badge-pill badge-danger"><?= count($cart['items'])?></span>
              </button>
              <div class="dropdown-menu dropdown-menu-right">
                <div class="row total-header-section">
                  <div class="col-lg-6 col-sm-6 col-6">
                    <i class="fa fa-shopping-cart" aria-hidden="true"></i> <span
                      class="badge badge-pill badge-danger"><?= count($cart['items'])?></span>
                  </div>
                  <div class="col-lg-6 col-sm-6 col-6 total-section text-right">
                    <p>Total Order: Rs. <span class="text-info"> <?= intval($cart['total'])?></span></p>
                  </div>
                </div>
                <div class="cart-detail-dropdown">
                  <?php if(!empty($cart['items'])): 
                    foreach($cart['items'] as $it) :?>
                  <div class="row cart-detail" data-cid="<?=$it['id'];?>">
                    <div class="col-lg-4 col-sm-4 col-4 cart-detail-img">
                        <?php if($it['image']=='') :?>
                        <img src="<?= base_url('/public/assets/images/lab-test.jpg')?>" class="img-fluid">
                        <?php else :?>
                        <img src="<?= base_url('/public/assets/images/tests/'.$it['image'])?>" class="img-fluid">
                        <?php endif;?>
                    </div>
                    <div class="col-lg-8 col-sm-8 col-8 cart-detail-product">
                      <p><?= $it['name'];?></p>
                      <span class="price text-info">Price Rs. <?= $it['price'];?></span>
                      <span class="price text-info">Total Price Rs. <?= $it['price'] * $it['quantity'];?></span> <span class="count"> Quantity:X<?= $it['quantity'];?></span>
                    </div>
                  </div>
                    <?php endforeach;
                  else :?>
                  <div class="row cart-detail">
                    <div class="col-lg-12 col-sm-12 col-12 cart-detail-product">
                    <p>No Product added to cart.</p>
                    </div>
                  </div>
                  <?php endif;?>
                </div>
                <div class="row">
                  <div class="col-6 text-center checkout">
                    <a href="<?= base_url('/cart')?>" class="btn btn-block btn-dark">Cart</a>
                  </div>
                  <div class="col-6 text-center checkout">
                    <a href="<?= base_url('/checkout')?>" class="btn btn-block btn-dark">Checkout</a>
                  </div>
                </div>
              </div>
            </div>
          </ul>
        </div>
      </div>
    </nav>
    <?php if(isset($breadcrumb)) :?>
    <nav class="breadcrumb-container bg-dark" aria-label="breadcrumb">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <?= $breadcrumb;?>
          </div>
        </div>
      </div>
    </nav>
    <?php endif;?>