<?= view('template/header'); ?>
<section class="outer-page-section pt-5 pb-3">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="tests-title">
                    <h2>All Available Tests</h2>
                    <button type="button" class="btn btn-dark shimmer clear-tests-filter"><i class="fas fa-times"></i>
                        Clear All Filters</button>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-4 order-2 order-lg-1">
                <div class="sidebar">
                    <div class="sidebar-title">
                    </div>
                    <div class="card text-white bg-secondary mb-2">
                        <div class="card-header shimmer">
                            Search
                        </div>
                        <div class="card-body">
                            <form method="get" class="filter-action" action="<?= base_url();?>/tests">
                                <div class="input-group">
                                    <input type="text" class="form-control" name="search" placeholder="Search here..."
                                        value="<?= isset($_GET['search']) ? $_GET['search'] : '';?>">
                                    <input type="hidden" name="service"
                                        value="<?= isset($_GET['service']) ? $_GET['service'] : '';?>">
                                    <input type="hidden" name="page" value="1">
                                    <div class="input-group-append text-white">
                                        <button class="btn btn-dark shimmer" type="submit"><i class="fa fa-search"
                                                aria-hidden="true"></i></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="card text-white bg-secondary">
                        <div class="card-header shimmer">
                            Services
                        </div>
                        <ul class="list-group list-group-flush text-dark">
                            <?php if($services) :
                        foreach($services as $s) : ?>
                            <li
                                class="list-group-item <?= isset($_GET['service']) && $_GET['service']== $s->id ? 'active' : '';?>">
                                <div class="filter-items filter-item-service" data-id="<?= $s->id;?>"> <i
                                        class="fas fa-caret-right"></i> <?= ucfirst($s->name);?></div>
                            </li>
                            <?php endforeach;
                    endif;?>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-md-8 order-1 order-lg-2 mb-5 mb-lg-0">
                <div class="row all-itmes">
                    <?php if($tests) :
                foreach($tests as $t) :
                $image = $t['image']=='' ? base_url('/public/assets/images/lab-test.jpg') : base_url().'/public/assets/images/tests/'.$t['image'];?>
                    <div class="col-md-4">
                        <div class="test-item">
                            <div class="test-item-image depth">
                                <a href="<?=base_url();?>/tests/<?= slugify($t['name'])?>/<?= encode_url($t['id']);?>">
                                    <div class="hovereffect"> <img class="img-fluid"
                                            src="<?=$image;?>">
                                    </div>
                                </a>
                            </div>
                            <div class="actions">
                                <?= $t['minprice'] != '' ? '<span class="price-tag">Starts at Rs. '.$t['minprice'].'</span>' : ''; ?>
                                <a href="<?=base_url();?>/tests/<?= slugify($t['name'])?>/<?= encode_url($t['id']);?>">
                                    <h4><?= ucfirst($t['name']);?> </h4>
                                </a>
                            </div>
                            
                        </div>
                    </div>
                    <?php endforeach;
                        endif; ?>
                </div>
                <div class="row">
                    <div class="col-md-12 mt-5">
                        <?php if ($pager) :?>
                        <?php //$pagi_path= 'codeigniter4/labs'; ?>
                        <?php //$pager->setPath($pagi_path); ?>
                        <?= $pager->links() ?>
                        <?php endif ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?= view('template/footer'); ?>