$(document).ready(function () {
    $(".labs-slider").owlCarousel({
        loop: true,
        margin: 20,
        nav: true,
        dots: false,
        animateOut: 'fadeOut',
        animateIn: 'fadeIn',
        autoHeight: false,
        autoplay: true,
        navText: ['<i class="fas fa-chevron-circle-left fa-2x"></i>', '<i class="fas fa-chevron-circle-right fa-2x"></i>'],
        responsive: {
            0: {
                items: 1,
            },
            480: {
                items: 3,
            },
            768: {
                items: 4,
            },
            1200: {
                items: 4,
            }
        }
    });
    var tickerLength = $('.animationtext ul li').length;
    var tickerHeight = $('.animationtext ul li').outerHeight();
    $('.animationtext ul li:last-child').prependTo('.animationtext ul');
    $('.animationtext ul').css('marginTop', -tickerHeight);

    $('[data-toggle="tooltip"]').tooltip();

    function moveTop() {
        $('.animationtext ul').animate({
            top: -tickerHeight
        }, 600, function () {
            $('.animationtext ul li:first-child').appendTo('.animationtext ul');
            $('.animationtext ul').css('top', '');
        });
    }
    setInterval(function () {
        moveTop();
    }, 2000);

    $('.searchbar, .animationtext').click(function () {
        $('.animationtext').hide();
        $('#searchbar').focus();
    });

    $('.close-icon').click(function () {
        $('#empty-message').hide();
    });


    var isMobile = false; //initiate as false
    // device detection
    if (/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)) {
        //e.preventDefault();
        isMobile = true;
    }
    jQuery('.specmegamenu, .megamenusec').hover(
        function () {
            jQuery(".megamenusec").css("display", 'block');
        },
        function () {
            jQuery(".megamenusec").css("display", 'none');
        }
    );
    $('.imglazy').lazy();

    $('.rlesscl').on('click', function (e) {
        $(this).hide();
        $('.rmorecl').show();
        $(".hideprop").fadeIn();
    });

    $('.rmorecl').on('click', function (e) {
        $(this).hide();
        $('.rlesscl').show();
        $(".hideprop").hide();
    });

    $('#downarrwo').on('click', function (e) {
        e.preventDefault();
        var desiredHeight = $(window).height() - 650;
        $('html, body').animate({
            scrollTop: $($(this).attr('href')).offset().top - 90
        }, 1000, 'linear');
    });
    $('.downarr').css('display', 'block');
    $(window).scroll(function (e) {
        e.preventDefault();
        if ($(window).scrollTop() > 50) {
            $(".downarr").fadeOut();
        } else {
            $(".downarr").fadeIn();
        }
    });
    var term = $("#searchbar").val();

    $('#searchbar').on('input', function () {
        if ($(this).val() == '') {
            $('#empty-message').css('display', 'none');
        } else {
            $('#empty-message').css('display', 'block');
        }
    });

    $(window).scroll(function () {
        if ($(this).scrollTop() > 300) {
            $('#scrolltop').fadeIn();
        } else {
            $('#scrolltop').fadeOut();
        }
    });
    $('#scrolltop').click(function () {
        $("html, body").animate({
            scrollTop: 0
        }, 600);
        return false;
    });

    jQuery(document).on('click', '.sign-up', function (e) {
        e.preventDefault();
        var elem = $('#sign-up-form');
        var that = this;
        var btnhtml = '';
        if ($(elem).find('input[name="otp"]').val() == '') {
            btnhtml = 'Sending';
        } else {
            btnhtml = 'Checking';
        }
        $.ajax({
            url: base_url + '/register',
            type: "POST",
            data: new FormData($('#sign-up-form')[0]),
            contentType: false,
            cache: false,
            processData: false,
            beforeSend: function () {
                $(that).html('<i class="fas fa-circle-notch fa-spin"></i> &nbsp; ' + btnhtml + ' ...');
            },
            success: function (data) {
                if (data.type == 'sending_otp') {
                    if (data.status == 0) {
                        $(that).html('Send OTP');
                        ShowNotificator('alert-danger', data.message);
                    } else {
                        $(elem).find('input[name="name"]').prop('readonly', true);
                        $(elem).find('input[name="mobile"]').prop('readonly', true);
                        $(elem).find('.otpdiv').removeClass('d-none');
                        $(that).html('Check OTP');
                        ShowNotificator('alert-success', data.message);
                    }
                } else {
                    if (data.status == 0) {
                        $(that).html('Send OTP');
                        ShowNotificator('alert-danger', data.message);
                    } else {
                        $(that).removeClass('btn-primary').addClass('btn-success').html('Registered');
                        location.href = base_url + '/my-account';
                    }
                }
            }
        });
    });

    jQuery(document).on('click', '.sign-in', function (e) {
        e.preventDefault();
        var elem = $('#sign-in-form');
        var that = this;
        var btnhtml = '';
        if ($(elem).find('input[name="otp"]').val() == '') {
            btnhtml = 'Sending';
        } else {
            btnhtml = 'Checking';
        }
        $.ajax({
            url: base_url + '/login',
            type: "POST",
            data: new FormData($('#sign-in-form')[0]),
            contentType: false,
            cache: false,
            processData: false,
            beforeSend: function () {
                $(that).html('<i class="fas fa-circle-notch fa-spin"></i> &nbsp; ' + btnhtml + ' ...');
            },
            success: function (data) {
                if (data.type == 'sending_otp') {
                    if (data.status == 0) {
                        $(that).html('Send OTP');
                        ShowNotificator('alert-danger', data.message);
                    } else {
                        $(elem).find('input[name="mobile"]').prop('readonly', true);
                        $(elem).find('.otpdiv').removeClass('d-none');
                        $(that).html('Check OTP');
                        ShowNotificator('alert-success', data.message);
                    }
                } else {
                    if (data.status == 0) {
                        $(that).html('Send OTP');
                        ShowNotificator('alert-danger', data.message);
                    } else {
                        $(that).removeClass('btn-primary').addClass('btn-success').html('Logged in');
                        location.href = base_url + '/my-account';
                    }
                }
            }
        });
    });

    jQuery(document).on('click', '.changeMobileBtn', function (e) {
        e.preventDefault();
        var elem = $('.mobile-changer-form');
        var that = this;
        var btnhtml = '';
        if ($(elem).find('input[name="otp"]').val() == '') {
            btnhtml = 'Sending OTP';
        } else {
            btnhtml = 'Checking';
        }
        var formdata = new FormData();
        formdata.append('mobile', $(elem).find('input[name="mobile"]').val());
        formdata.append('otp', $(elem).find('input[name="otp"]').val());
        $.ajax({
            url: base_url + '/users/changeMobile',
            type: "POST",
            data: formdata,
            contentType: false,
            cache: false,
            processData: false,
            beforeSend: function () {
                $(that).html('<i class="fas fa-circle-notch fa-spin"></i> &nbsp; ' + btnhtml + ' ...');
            },
            success: function (data) {
                if (data.type == 'sending_otp') {
                    if (data.status == 0) {
                        $(that).html('Send OTP');
                        ShowNotificator('alert-danger', data.message);
                    } else {
                        $('.showing_mobile').html($(elem).find('input[name="mobile"]').val());
                        $(elem).find('input[name="mobile"]').prop('readonly', true);
                        $(elem).find('.otpInput').removeClass('d-none');
                        $(that).html('Check OTP');
                        ShowNotificator('alert-success', data.message);
                    }
                } else {
                    if (data.status == 0) {
                        $(that).html('Check OTP');
                        ShowNotificator('alert-danger', data.message);
                    } else {
                        $(elem).find('input[name="mobile"]').prop('readonly', false);
                        ShowNotificator('alert-success', data.message);
                        $(elem).find('.otpInput').addClass('d-none');
                        $(that).html('Change');
                    }
                }
            }
        });
    });

    if($('#profileImageUpload').length!=0) {
        var imageUploader = $("#profileImageUpload").withDropZone(".drop-zone", {
            url: base_url+'/users/profileimageupload',
            uploadBegin: function(filename, fileIndex, blob) {
            $('.file-uploader-progress-bar').removeClass('invisible');
            },
            uploadEnd: function(filename, fileIndex, blob) {
                
            },
            done: function(filename, data){            
                $('.file-uploader-progress-bar').addClass('invisible');
                if(data.status) {
                    $('.dropzone-mask').prepend('<button type="button" data-placement="top" data-img="' + data.image + '" title="Remove Profile Image" data-toggle="tooltip" class="btn btn-lg btn-danger removeImg"><i class="fas fa-trash"></i></button>');
                    $('[data-toggle="tooltip"]').tooltip();
                    ShowNotificator('alert-success', data.message);
                } else {
                    ShowNotificator('alert-danger', data.message);
                }
            },
            action: function(fileIndex){   
            return {
                name: "image",
                params: {
                preview: true,
                }
            }
            },
            ifWrongFile: "ignore",
            wrapperForInvalidFile: function(fileIndex) {
            return ShowNotificator('alert-danger', 'File: "${this.files[fileIndex].name}" doesn\'t support');
            },      
            multiUploading: false,
            formData: function(fileIndex, blob, filename) {
            var fd = new FormData();
            fd.append('userpic', $('input[type="file"][name="file"]')[0].files[0]);
            return fd;
            },      
            ajaxSettings: function(settings, index, filename, blob){
            settings.error = function(e) {
                return ShowNotificator('alert-danger', 'Something went wrong while uploading profile image.');
            }
            }
        });
        $("#upload_images").click(imageUploader.upload);
    }

    $(document).on('click', '.removeImg', function (e) {
		var formdata = new FormData();
		formdata.append('img', jQuery(this).data('img'));
		var that = this;
        $.ajax({
            url: base_url + '/users/remove_img',
			headers: {'X-Requested-With': 'XMLHttpRequest'},
            type: "POST",
            data: formdata,
            contentType: false,
            cache: false,
            processData: false,
            success: function(data) {
                $(that).next('.drop-zone').removeClass('drop');                
                $(that).next('.drop-zone').find('.preview-container').empty();
                $('.dropzone-mask').find('button').remove();
                ShowNotificator('alert-danger', data.message);
            }
        });
	});
});

function __highlight(s, t) {
    var matcher = new RegExp("(" + $.ui.autocomplete.escapeRegex(t) + ")", "ig");
    return s.replace(matcher, "<strong>$1</strong>");
}

jQuery(window).on('load', function () {
    jQuery(".loader").fadeOut();
});

function ShowNotificator(add_class, the_text) {
    $('div#notificator').html(the_text).addClass(add_class).slideDown('slow').delay(3000).slideUp('slow', function () {
        $(this).removeClass(add_class).empty();
    });
}