$(document).ready(function () {

    /* Filters on Shop Page */
    $(document).on('click', '.filter-items', function () {
        var target = $('.filter-action'),
            id = $(this).data('id');
        if ($(this).hasClass('filter-item-service')) {
            $(target).find('input[type="hidden"][name="service"]').val(id);
        }
        $(target).submit();
    });

    $(document).on('click', '.clear-tests-filter', function () {
        var target = $('.filter-action');
        $(target).find('input').val('');
        $(target).submit();
    });

    /* Price select on single page */
    $(document).on('click', '.price-selector input[name="price_selected"]', function () {
        $('.price-selector button').prop('disabled', true);
        $(this).parent().next().children('button').prop('disabled', false);
    });

    /* Apply Promocode */
    $(document).on('click', '.promocode-applyer button', function () {
        var that = this;
        var enteredCode = $('.promocode-applyer input').val();
        if(enteredCode=='') {
            ShowNotificator('alert-info', 'Promocode is empty.');
            return false;
        }
        $.ajax({
            type: "POST",
            url: base_url+'/checkout/check-promocode',
            data: {enteredCode: enteredCode, remove: 'no'}
        }).done(function (data) {
            if (data.status == 0) {
                ShowNotificator('alert-danger', 'Promocode Invalid.');
            } else {
                $('.promocode-applyer input').prop('readonly', true);
                $(that).prop('disabled', true);
                $('.discount_amount p.mb-0 span').html('Rs. ' + data.dicountAmount);
                $('.order_total p span').html('Rs. ' + data.finalAmount);
                if(data.type=='percent') {
                    $('.promocode-applyer .promocode-text p.small').html('Promocode applied with ' + data.discountMainAmount + '% <a href="javascript:;" data-toggle="tooltip" title="Remove Applied Promocode" class="removeDiscount">Remove</a>');
                } else {
                    $('.promocode-applyer .promocode-text  p.small').html('Promocode applied with Flat Rs. ' + data.discountMainAmount + ' <a href="javascript:;" data-toggle="tooltip" title="Remove Applied Promocode" class="removeDiscount">Remove</a>');
                }
                $('[data-toggle="tooltip"]').tooltip();
                ShowNotificator('alert-success', 'Promocode Applied Successfully.');
            }
        });
    });

    /* Remove Promocode */
    $(document).on('click', '.removeDiscount', function(e) {
        $.ajax({
            type: "POST",
            url: base_url+'/checkout/check-promocode',
            data: {remove: 'yes'}
        }).done(function (data) {
            if (data.status == 0) {
                ShowNotificator('alert-danger', 'Unable to remove promocode.');
            } else {
                $('.promocode-applyer input').prop('readonly', false);
                $('.promocode-applyer button').prop('disabled', false);
                $('.discount_amount p.mb-0 span').html('Rs. 0');
                $('.order_total p span').html('Rs. ' + data.finalAmount);
                $('.promocode-applyer .promocode-text  p.small').empty();
                ShowNotificator('alert-success', 'Promocode Removed Successfully.');
            }
        });
    });

    /* Add Product to Shopping Cart */
    $(document).on('click', '.add-to-cart', function () {
        var reload = false;
        var ids = [];
        ids.testid = $(this).data('testid');
        ids.tbpid = $(this).data('tbpid');
        var goto_site = $(this).data('goto');
        if (goto_site != null) {
            reload = goto_site;
        }
        manageShoppingCart('add', ids, reload);
    });

    /* Remove Product from Shopping Cart */
    $(document).on('click', '.remove-cart', function () {
        var reload = false;
        var ids = [];
        ids.testid = $(this).data('id');
        ids.tbpid = 0;
        manageShoppingCart('remove', ids, reload);
    });

    /* Single Product Increment Decrement */
    $(document).on('change', '.update-cart', function () {
        var reload = false;
        var ids = [];
        ids.testid = $(this).data('id');
        ids.tbpid = 0;
        ids.qty = $(this).val();
        manageShoppingCart('update', ids, reload);        
    });
});

/* Manage Full Shopping Cart */
function manageShoppingCart(action, article_id, reload) {
    var qty = 0;
    if (action=='update') {
        qty = article_id.qty;
    }
    $.ajax({
        type: "POST",
        url: base_url + '/manageShoppingCart',
        data: {
            test_id: article_id.testid,
            tbpid: article_id.tbpid,
            quantity: qty,
            action: action
        }
    }).done(function (data) {
        if (action == 'update') {
            var price = parseInt($('.cart-row[data-id="' + article_id.testid + '"]').find('.cart-row-price').text());
            var newtotal = price * parseInt(article_id.qty);
            $('.cart-row[data-id="' + article_id.testid + '"]').find('.cart-row-total').html(newtotal);
        }
        if (action == 'remove') {
            $('.cart-row[data-id="' + article_id.testid + '"]').remove();
        }
        if (reload == true) {
            location.reload(false);
            return;
        } else if (typeof reload == 'string') {
            location.href = reload;
            return;
        }
        var elem = $('.cart-detail-dropdown');
        if((data.items).length==0) {
            $(elem).html('<div class="row cart-detail">\
            <div class="col-lg-12 col-sm-12 col-12 cart-detail-product">\
            <p>No Product added to cart.</p>\
            </div>\
          </div>');
          $('.cart-table tbody').html('<tr>\
                <td colspan="4" class="">\
                    <h4 class="p-3">Cart is empty.</h4>\
                </td>\
            </tr>');
        } else {            
            $(elem).empty();
            $(data.items).each(function(key, value) {
                var price = value.price*value.quantity;
                $(elem).append('<div class="row cart-detail" data-cid="'+value.id+'">\
                <div class="col-lg-4 col-sm-4 col-4 cart-detail-img">\
                  <img src="'+base_url+'/public/assets/images/tests/'+value.image+'">\
                </div>\
                <div class="col-lg-8 col-sm-8 col-8 cart-detail-product">\
                  <p>'+value.name+'</p>\
                  <span class="price text-info"> Rs. '+value.price+'</span> <span class="count">\ Quantity: '+value.quantity+'</span>\
                </div>\
              </div>');
            });
        }
        $('.cart-total, .total-header-section .text-info').html(data.total);
        $('.cart-dropdown .badge').html((data.items).length);
        ShowNotificator('alert-info', data.message);
    });
}