<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Controllers;

use Core\Request\Parameters\QueryParam;
use Core\Response\Types\ErrorType;
use CoreInterfaces\Core\Request\RequestMethod;
use PaypalServerSdkLib\Exceptions\DefaultErrorException;
use PaypalServerSdkLib\Exceptions\SearchErrorException;
use PaypalServerSdkLib\Http\ApiResponse;
use PaypalServerSdkLib\Models\BalancesResponse;
use PaypalServerSdkLib\Models\SearchResponse;

class TransactionSearchController extends BaseController
{
    /**
     * Lists transactions. Specify one or more query parameters to filter the transaction that appear in
     * the response. Notes: If you specify one or more optional query parameters, the ending_balance
     * response field is empty. It takes a maximum of three hours for executed transactions to appear in
     * the list transactions call. This call lists transaction for the previous three years.
     *
     * @param array $options Array with all options for search
     *
     * @return ApiResponse Response from the API call
     */
    public function searchTransactions(array $options): ApiResponse
    {
        $_reqBuilder = $this->requestBuilder(RequestMethod::GET, '/v1/reporting/transactions')
            ->auth('Oauth2')
            ->parameters(
                QueryParam::init('start_date', $options)->extract('startDate'),
                QueryParam::init('end_date', $options)->extract('endDate'),
                QueryParam::init('transaction_id', $options)->extract('transactionId'),
                QueryParam::init('transaction_type', $options)->extract('transactionType'),
                QueryParam::init('transaction_status', $options)->extract('transactionStatus'),
                QueryParam::init('transaction_amount', $options)->extract('transactionAmount'),
                QueryParam::init('transaction_currency', $options)->extract('transactionCurrency'),
                QueryParam::init('payment_instrument_type', $options)->extract('paymentInstrumentType'),
                QueryParam::init('store_id', $options)->extract('storeId'),
                QueryParam::init('terminal_id', $options)->extract('terminalId'),
                QueryParam::init('fields', $options)->extract('fields', 'transaction_info'),
                QueryParam::init('balance_affecting_records_only', $options)
                    ->extract('balanceAffectingRecordsOnly', 'Y'),
                QueryParam::init('page_size', $options)->extract('pageSize', 100),
                QueryParam::init('page', $options)->extract('page', 1)
            );

        $_resHandler = $this->responseHandler()
            ->throwErrorOn('0', ErrorType::init('The error response.', SearchErrorException::class))
            ->type(SearchResponse::class)
            ->returnApiResponse();

        return $this->execute($_reqBuilder, $_resHandler);
    }

    /**
     * List all balances. Specify date time to list balances for that time that appear in the response.
     * Notes: It takes a maximum of three hours for balances to appear in the list balances call. This call
     * lists balances upto the previous three years.
     *
     * @param array $options Array with all options for search
     *
     * @return ApiResponse Response from the API call
     */
    public function searchBalances(array $options): ApiResponse
    {
        $_reqBuilder = $this->requestBuilder(RequestMethod::GET, '/v1/reporting/balances')
            ->auth('Oauth2')
            ->parameters(
                QueryParam::init('as_of_time', $options)->extract('asOfTime'),
                QueryParam::init('currency_code', $options)->extract('currencyCode')
            );

        $_resHandler = $this->responseHandler()
            ->throwErrorOn(
                '400',
                ErrorType::init(
                    'The request is not well-formed, is syntactically incorrect, or violates schema.',
                    DefaultErrorException::class
                )
            )
            ->throwErrorOn(
                '403',
                ErrorType::init(
                    'Authorization failed due to insufficient permissions.',
                    DefaultErrorException::class
                )
            )
            ->throwErrorOn(
                '500',
                ErrorType::init('An internal server error occurred.', DefaultErrorException::class)
            )
            ->throwErrorOn('0', ErrorType::init('The error response.', DefaultErrorException::class))
            ->type(BalancesResponse::class)
            ->returnApiResponse();

        return $this->execute($_reqBuilder, $_resHandler);
    }
}
