<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * Merchant provided details of the native app or mobile web browser to facilitate buyer's app switch
 * to the PayPal consumer app.
 */
class AppSwitchContext implements \JsonSerializable
{
    /**
     * @var NativeAppContext|null
     */
    private $nativeApp;

    /**
     * @var MobileWebContext|null
     */
    private $mobileWeb;

    /**
     * Returns Native App.
     * Merchant provided, buyer's native app preferences to app switch to the PayPal consumer app.
     */
    public function getNativeApp(): ?NativeAppContext
    {
        return $this->nativeApp;
    }

    /**
     * Sets Native App.
     * Merchant provided, buyer's native app preferences to app switch to the PayPal consumer app.
     *
     * @maps native_app
     */
    public function setNativeApp(?NativeAppContext $nativeApp): void
    {
        $this->nativeApp = $nativeApp;
    }

    /**
     * Returns Mobile Web.
     * Buyer's mobile web browser context to app switch to the PayPal consumer app.
     */
    public function getMobileWeb(): ?MobileWebContext
    {
        return $this->mobileWeb;
    }

    /**
     * Sets Mobile Web.
     * Buyer's mobile web browser context to app switch to the PayPal consumer app.
     *
     * @maps mobile_web
     */
    public function setMobileWeb(?MobileWebContext $mobileWeb): void
    {
        $this->mobileWeb = $mobileWeb;
    }

    /**
     * Converts the AppSwitchContext object to a human-readable string representation.
     *
     * @return string The string representation of the AppSwitchContext object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'AppSwitchContext',
            ['nativeApp' => $this->nativeApp, 'mobileWeb' => $this->mobileWeb]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->nativeApp)) {
            $json['native_app'] = $this->nativeApp;
        }
        if (isset($this->mobileWeb)) {
            $json['mobile_web'] = $this->mobileWeb;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
