<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * Customizes the payer experience during the approval process for the payment.
 */
class ApplePayExperienceContext implements \JsonSerializable
{
    /**
     * @var string
     */
    private $returnUrl;

    /**
     * @var string
     */
    private $cancelUrl;

    /**
     * @param string $returnUrl
     * @param string $cancelUrl
     */
    public function __construct(string $returnUrl, string $cancelUrl)
    {
        $this->returnUrl = $returnUrl;
        $this->cancelUrl = $cancelUrl;
    }

    /**
     * Returns Return Url.
     * Describes the URL.
     */
    public function getReturnUrl(): string
    {
        return $this->returnUrl;
    }

    /**
     * Sets Return Url.
     * Describes the URL.
     *
     * @required
     * @maps return_url
     */
    public function setReturnUrl(string $returnUrl): void
    {
        $this->returnUrl = $returnUrl;
    }

    /**
     * Returns Cancel Url.
     * Describes the URL.
     */
    public function getCancelUrl(): string
    {
        return $this->cancelUrl;
    }

    /**
     * Sets Cancel Url.
     * Describes the URL.
     *
     * @required
     * @maps cancel_url
     */
    public function setCancelUrl(string $cancelUrl): void
    {
        $this->cancelUrl = $cancelUrl;
    }

    /**
     * Converts the ApplePayExperienceContext object to a human-readable string representation.
     *
     * @return string The string representation of the ApplePayExperienceContext object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'ApplePayExperienceContext',
            ['returnUrl' => $this->returnUrl, 'cancelUrl' => $this->cancelUrl]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        $json['return_url'] = $this->returnUrl;
        $json['cancel_url'] = $this->cancelUrl;

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
