<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The auction information.
 */
class AuctionInformation implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $auctionSite;

    /**
     * @var string|null
     */
    private $auctionItemSite;

    /**
     * @var string|null
     */
    private $auctionBuyerId;

    /**
     * @var string|null
     */
    private $auctionClosingDate;

    /**
     * Returns Auction Site.
     * The name of the auction site.
     */
    public function getAuctionSite(): ?string
    {
        return $this->auctionSite;
    }

    /**
     * Sets Auction Site.
     * The name of the auction site.
     *
     * @maps auction_site
     */
    public function setAuctionSite(?string $auctionSite): void
    {
        $this->auctionSite = $auctionSite;
    }

    /**
     * Returns Auction Item Site.
     * The auction site URL.
     */
    public function getAuctionItemSite(): ?string
    {
        return $this->auctionItemSite;
    }

    /**
     * Sets Auction Item Site.
     * The auction site URL.
     *
     * @maps auction_item_site
     */
    public function setAuctionItemSite(?string $auctionItemSite): void
    {
        $this->auctionItemSite = $auctionItemSite;
    }

    /**
     * Returns Auction Buyer Id.
     * The ID of the buyer who makes the purchase in the auction. This ID might be different from the payer
     * ID provided for the payment.
     */
    public function getAuctionBuyerId(): ?string
    {
        return $this->auctionBuyerId;
    }

    /**
     * Sets Auction Buyer Id.
     * The ID of the buyer who makes the purchase in the auction. This ID might be different from the payer
     * ID provided for the payment.
     *
     * @maps auction_buyer_id
     */
    public function setAuctionBuyerId(?string $auctionBuyerId): void
    {
        $this->auctionBuyerId = $auctionBuyerId;
    }

    /**
     * Returns Auction Closing Date.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     */
    public function getAuctionClosingDate(): ?string
    {
        return $this->auctionClosingDate;
    }

    /**
     * Sets Auction Closing Date.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     *
     * @maps auction_closing_date
     */
    public function setAuctionClosingDate(?string $auctionClosingDate): void
    {
        $this->auctionClosingDate = $auctionClosingDate;
    }

    /**
     * Converts the AuctionInformation object to a human-readable string representation.
     *
     * @return string The string representation of the AuctionInformation object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'AuctionInformation',
            [
                'auctionSite' => $this->auctionSite,
                'auctionItemSite' => $this->auctionItemSite,
                'auctionBuyerId' => $this->auctionBuyerId,
                'auctionClosingDate' => $this->auctionClosingDate
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->auctionSite)) {
            $json['auction_site']         = $this->auctionSite;
        }
        if (isset($this->auctionItemSite)) {
            $json['auction_item_site']    = $this->auctionItemSite;
        }
        if (isset($this->auctionBuyerId)) {
            $json['auction_buyer_id']     = $this->auctionBuyerId;
        }
        if (isset($this->auctionClosingDate)) {
            $json['auction_closing_date'] = $this->auctionClosingDate;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
