<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * A Resource representing a request to vault a Bank used for ACH Debit.
 */
class BankRequest implements \JsonSerializable
{
    /**
     * @var mixed
     */
    private $achDebit;

    /**
     * @var SepaDebitRequest|null
     */
    private $sepaDebit;

    /**
     * Returns Ach Debit.
     * A Resource representing a request to vault a ACH Debit.
     *
     * @return mixed
     */
    public function getAchDebit()
    {
        return $this->achDebit;
    }

    /**
     * Sets Ach Debit.
     * A Resource representing a request to vault a ACH Debit.
     *
     * @maps ach_debit
     *
     * @param mixed $achDebit
     */
    public function setAchDebit($achDebit): void
    {
        $this->achDebit = $achDebit;
    }

    /**
     * Returns Sepa Debit.
     * An API resource denoting a request to securely store a SEPA Debit.
     */
    public function getSepaDebit(): ?SepaDebitRequest
    {
        return $this->sepaDebit;
    }

    /**
     * Sets Sepa Debit.
     * An API resource denoting a request to securely store a SEPA Debit.
     *
     * @maps sepa_debit
     */
    public function setSepaDebit(?SepaDebitRequest $sepaDebit): void
    {
        $this->sepaDebit = $sepaDebit;
    }

    /**
     * Converts the BankRequest object to a human-readable string representation.
     *
     * @return string The string representation of the BankRequest object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'BankRequest',
            ['achDebit' => $this->achDebit, 'sepaDebit' => $this->sepaDebit]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->achDebit)) {
            $json['ach_debit']  = $this->achDebit;
        }
        if (isset($this->sepaDebit)) {
            $json['sepa_debit'] = $this->sepaDebit;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
