<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The billing cycle details to override at subscription level. The subscription billing cycle
 * definition has to adhere to the plan billing cycle definition.
 */
class BillingCycleOverride implements \JsonSerializable
{
    /**
     * @var SubscriptionPricingScheme|null
     */
    private $pricingScheme;

    /**
     * @var int
     */
    private $sequence;

    /**
     * @var int|null
     */
    private $totalCycles;

    /**
     * @param int $sequence
     */
    public function __construct(int $sequence)
    {
        $this->sequence = $sequence;
    }

    /**
     * Returns Pricing Scheme.
     * The pricing scheme details.
     */
    public function getPricingScheme(): ?SubscriptionPricingScheme
    {
        return $this->pricingScheme;
    }

    /**
     * Sets Pricing Scheme.
     * The pricing scheme details.
     *
     * @maps pricing_scheme
     */
    public function setPricingScheme(?SubscriptionPricingScheme $pricingScheme): void
    {
        $this->pricingScheme = $pricingScheme;
    }

    /**
     * Returns Sequence.
     * The order in which this cycle is to run among other billing cycles. For example, a trial billing
     * cycle has a `sequence` of `1` while a regular billing cycle has a `sequence` of `2`, so that trial
     * cycle runs before the regular cycle.
     */
    public function getSequence(): int
    {
        return $this->sequence;
    }

    /**
     * Sets Sequence.
     * The order in which this cycle is to run among other billing cycles. For example, a trial billing
     * cycle has a `sequence` of `1` while a regular billing cycle has a `sequence` of `2`, so that trial
     * cycle runs before the regular cycle.
     *
     * @required
     * @maps sequence
     */
    public function setSequence(int $sequence): void
    {
        $this->sequence = $sequence;
    }

    /**
     * Returns Total Cycles.
     * The number of times this billing cycle gets executed. Trial billing cycles can only be executed a
     * finite number of times (value between 1 and 999 for total_cycles). Regular billing cycles can be
     * executed infinite times (value of 0 for total_cycles) or a finite number of times (value between 1
     * and 999 for total_cycles).
     */
    public function getTotalCycles(): ?int
    {
        return $this->totalCycles;
    }

    /**
     * Sets Total Cycles.
     * The number of times this billing cycle gets executed. Trial billing cycles can only be executed a
     * finite number of times (value between 1 and 999 for total_cycles). Regular billing cycles can be
     * executed infinite times (value of 0 for total_cycles) or a finite number of times (value between 1
     * and 999 for total_cycles).
     *
     * @maps total_cycles
     */
    public function setTotalCycles(?int $totalCycles): void
    {
        $this->totalCycles = $totalCycles;
    }

    /**
     * Converts the BillingCycleOverride object to a human-readable string representation.
     *
     * @return string The string representation of the BillingCycleOverride object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'BillingCycleOverride',
            [
                'pricingScheme' => $this->pricingScheme,
                'sequence' => $this->sequence,
                'totalCycles' => $this->totalCycles
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->pricingScheme)) {
            $json['pricing_scheme'] = $this->pricingScheme;
        }
        $json['sequence']           = $this->sequence;
        if (isset($this->totalCycles)) {
            $json['total_cycles']   = $this->totalCycles;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
