<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The plan details.
 */
class BillingPlan implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $id;

    /**
     * @var string|null
     */
    private $productId;

    /**
     * @var string|null
     */
    private $name;

    /**
     * @var string|null
     */
    private $status;

    /**
     * @var string|null
     */
    private $description;

    /**
     * @var SubscriptionBillingCycle[]|null
     */
    private $billingCycles;

    /**
     * @var PaymentPreferences|null
     */
    private $paymentPreferences;

    /**
     * @var MerchantPreferences|null
     */
    private $merchantPreferences;

    /**
     * @var Taxes|null
     */
    private $taxes;

    /**
     * @var bool|null
     */
    private $quantitySupported = false;

    /**
     * @var string|null
     */
    private $createTime;

    /**
     * @var string|null
     */
    private $updateTime;

    /**
     * @var LinkDescription[]|null
     */
    private $links;

    /**
     * Returns Id.
     * The unique PayPal-generated ID for the plan.
     */
    public function getId(): ?string
    {
        return $this->id;
    }

    /**
     * Sets Id.
     * The unique PayPal-generated ID for the plan.
     *
     * @maps id
     */
    public function setId(?string $id): void
    {
        $this->id = $id;
    }

    /**
     * Returns Product Id.
     * The ID for the product.
     */
    public function getProductId(): ?string
    {
        return $this->productId;
    }

    /**
     * Sets Product Id.
     * The ID for the product.
     *
     * @maps product_id
     */
    public function setProductId(?string $productId): void
    {
        $this->productId = $productId;
    }

    /**
     * Returns Name.
     * The plan name.
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * Sets Name.
     * The plan name.
     *
     * @maps name
     */
    public function setName(?string $name): void
    {
        $this->name = $name;
    }

    /**
     * Returns Status.
     * The plan status.
     */
    public function getStatus(): ?string
    {
        return $this->status;
    }

    /**
     * Sets Status.
     * The plan status.
     *
     * @maps status
     */
    public function setStatus(?string $status): void
    {
        $this->status = $status;
    }

    /**
     * Returns Description.
     * The detailed description of the plan.
     */
    public function getDescription(): ?string
    {
        return $this->description;
    }

    /**
     * Sets Description.
     * The detailed description of the plan.
     *
     * @maps description
     */
    public function setDescription(?string $description): void
    {
        $this->description = $description;
    }

    /**
     * Returns Billing Cycles.
     * An array of billing cycles for trial billing and regular billing. A plan can have at most two trial
     * cycles and only one regular cycle.
     *
     * @return SubscriptionBillingCycle[]|null
     */
    public function getBillingCycles(): ?array
    {
        return $this->billingCycles;
    }

    /**
     * Sets Billing Cycles.
     * An array of billing cycles for trial billing and regular billing. A plan can have at most two trial
     * cycles and only one regular cycle.
     *
     * @maps billing_cycles
     *
     * @param SubscriptionBillingCycle[]|null $billingCycles
     */
    public function setBillingCycles(?array $billingCycles): void
    {
        $this->billingCycles = $billingCycles;
    }

    /**
     * Returns Payment Preferences.
     * The payment preferences for a subscription.
     */
    public function getPaymentPreferences(): ?PaymentPreferences
    {
        return $this->paymentPreferences;
    }

    /**
     * Sets Payment Preferences.
     * The payment preferences for a subscription.
     *
     * @maps payment_preferences
     */
    public function setPaymentPreferences(?PaymentPreferences $paymentPreferences): void
    {
        $this->paymentPreferences = $paymentPreferences;
    }

    /**
     * Returns Merchant Preferences.
     * The merchant preferences for a subscription.
     */
    public function getMerchantPreferences(): ?MerchantPreferences
    {
        return $this->merchantPreferences;
    }

    /**
     * Sets Merchant Preferences.
     * The merchant preferences for a subscription.
     *
     * @maps merchant_preferences
     */
    public function setMerchantPreferences(?MerchantPreferences $merchantPreferences): void
    {
        $this->merchantPreferences = $merchantPreferences;
    }

    /**
     * Returns Taxes.
     * The tax details.
     */
    public function getTaxes(): ?Taxes
    {
        return $this->taxes;
    }

    /**
     * Sets Taxes.
     * The tax details.
     *
     * @maps taxes
     */
    public function setTaxes(?Taxes $taxes): void
    {
        $this->taxes = $taxes;
    }

    /**
     * Returns Quantity Supported.
     * Indicates whether you can subscribe to this plan by providing a quantity for the goods or service.
     */
    public function getQuantitySupported(): ?bool
    {
        return $this->quantitySupported;
    }

    /**
     * Sets Quantity Supported.
     * Indicates whether you can subscribe to this plan by providing a quantity for the goods or service.
     *
     * @maps quantity_supported
     */
    public function setQuantitySupported(?bool $quantitySupported): void
    {
        $this->quantitySupported = $quantitySupported;
    }

    /**
     * Returns Create Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     */
    public function getCreateTime(): ?string
    {
        return $this->createTime;
    }

    /**
     * Sets Create Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     *
     * @maps create_time
     */
    public function setCreateTime(?string $createTime): void
    {
        $this->createTime = $createTime;
    }

    /**
     * Returns Update Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     */
    public function getUpdateTime(): ?string
    {
        return $this->updateTime;
    }

    /**
     * Sets Update Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     *
     * @maps update_time
     */
    public function setUpdateTime(?string $updateTime): void
    {
        $this->updateTime = $updateTime;
    }

    /**
     * Returns Links.
     * An array of request-related [HATEOAS links](/docs/api/reference/api-responses/#hateoas-links).
     *
     * @return LinkDescription[]|null
     */
    public function getLinks(): ?array
    {
        return $this->links;
    }

    /**
     * Sets Links.
     * An array of request-related [HATEOAS links](/docs/api/reference/api-responses/#hateoas-links).
     *
     * @maps links
     *
     * @param LinkDescription[]|null $links
     */
    public function setLinks(?array $links): void
    {
        $this->links = $links;
    }

    /**
     * Converts the BillingPlan object to a human-readable string representation.
     *
     * @return string The string representation of the BillingPlan object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'BillingPlan',
            [
                'id' => $this->id,
                'productId' => $this->productId,
                'name' => $this->name,
                'status' => $this->status,
                'description' => $this->description,
                'billingCycles' => $this->billingCycles,
                'paymentPreferences' => $this->paymentPreferences,
                'merchantPreferences' => $this->merchantPreferences,
                'taxes' => $this->taxes,
                'quantitySupported' => $this->quantitySupported,
                'createTime' => $this->createTime,
                'updateTime' => $this->updateTime,
                'links' => $this->links
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->id)) {
            $json['id']                   = $this->id;
        }
        if (isset($this->productId)) {
            $json['product_id']           = $this->productId;
        }
        if (isset($this->name)) {
            $json['name']                 = $this->name;
        }
        if (isset($this->status)) {
            $json['status']               = $this->status;
        }
        if (isset($this->description)) {
            $json['description']          = $this->description;
        }
        if (isset($this->billingCycles)) {
            $json['billing_cycles']       = $this->billingCycles;
        }
        if (isset($this->paymentPreferences)) {
            $json['payment_preferences']  = $this->paymentPreferences;
        }
        if (isset($this->merchantPreferences)) {
            $json['merchant_preferences'] = $this->merchantPreferences;
        }
        if (isset($this->taxes)) {
            $json['taxes']                = $this->taxes;
        }
        if (isset($this->quantitySupported)) {
            $json['quantity_supported']   = $this->quantitySupported;
        }
        if (isset($this->createTime)) {
            $json['create_time']          = $this->createTime;
        }
        if (isset($this->updateTime)) {
            $json['update_time']          = $this->updateTime;
        }
        if (isset($this->links)) {
            $json['links']                = $this->links;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
