<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\AppSwitchContext;
use PaypalServerSdkLib\Models\MobileWebContext;
use PaypalServerSdkLib\Models\NativeAppContext;

/**
 * Builder for model AppSwitchContext
 *
 * @see AppSwitchContext
 */
class AppSwitchContextBuilder
{
    /**
     * @var AppSwitchContext
     */
    private $instance;

    private function __construct(AppSwitchContext $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new App Switch Context Builder object.
     */
    public static function init(): self
    {
        return new self(new AppSwitchContext());
    }

    /**
     * Sets native app field.
     *
     * @param NativeAppContext|null $value
     */
    public function nativeApp(?NativeAppContext $value): self
    {
        $this->instance->setNativeApp($value);
        return $this;
    }

    /**
     * Sets mobile web field.
     *
     * @param MobileWebContext|null $value
     */
    public function mobileWeb(?MobileWebContext $value): self
    {
        $this->instance->setMobileWeb($value);
        return $this;
    }

    /**
     * Initializes a new App Switch Context object.
     */
    public function build(): AppSwitchContext
    {
        return CoreHelper::clone($this->instance);
    }
}
