<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\AuctionInformation;

/**
 * Builder for model AuctionInformation
 *
 * @see AuctionInformation
 */
class AuctionInformationBuilder
{
    /**
     * @var AuctionInformation
     */
    private $instance;

    private function __construct(AuctionInformation $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Auction Information Builder object.
     */
    public static function init(): self
    {
        return new self(new AuctionInformation());
    }

    /**
     * Sets auction site field.
     *
     * @param string|null $value
     */
    public function auctionSite(?string $value): self
    {
        $this->instance->setAuctionSite($value);
        return $this;
    }

    /**
     * Sets auction item site field.
     *
     * @param string|null $value
     */
    public function auctionItemSite(?string $value): self
    {
        $this->instance->setAuctionItemSite($value);
        return $this;
    }

    /**
     * Sets auction buyer id field.
     *
     * @param string|null $value
     */
    public function auctionBuyerId(?string $value): self
    {
        $this->instance->setAuctionBuyerId($value);
        return $this;
    }

    /**
     * Sets auction closing date field.
     *
     * @param string|null $value
     */
    public function auctionClosingDate(?string $value): self
    {
        $this->instance->setAuctionClosingDate($value);
        return $this;
    }

    /**
     * Initializes a new Auction Information object.
     */
    public function build(): AuctionInformation
    {
        return CoreHelper::clone($this->instance);
    }
}
