<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\BillingPlan;
use PaypalServerSdkLib\Models\LinkDescription;
use PaypalServerSdkLib\Models\MerchantPreferences;
use PaypalServerSdkLib\Models\PaymentPreferences;
use PaypalServerSdkLib\Models\SubscriptionBillingCycle;
use PaypalServerSdkLib\Models\Taxes;

/**
 * Builder for model BillingPlan
 *
 * @see BillingPlan
 */
class BillingPlanBuilder
{
    /**
     * @var BillingPlan
     */
    private $instance;

    private function __construct(BillingPlan $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Billing Plan Builder object.
     */
    public static function init(): self
    {
        return new self(new BillingPlan());
    }

    /**
     * Sets id field.
     *
     * @param string|null $value
     */
    public function id(?string $value): self
    {
        $this->instance->setId($value);
        return $this;
    }

    /**
     * Sets product id field.
     *
     * @param string|null $value
     */
    public function productId(?string $value): self
    {
        $this->instance->setProductId($value);
        return $this;
    }

    /**
     * Sets name field.
     *
     * @param string|null $value
     */
    public function name(?string $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Sets status field.
     *
     * @param string|null $value
     */
    public function status(?string $value): self
    {
        $this->instance->setStatus($value);
        return $this;
    }

    /**
     * Sets description field.
     *
     * @param string|null $value
     */
    public function description(?string $value): self
    {
        $this->instance->setDescription($value);
        return $this;
    }

    /**
     * Sets billing cycles field.
     *
     * @param SubscriptionBillingCycle[]|null $value
     */
    public function billingCycles(?array $value): self
    {
        $this->instance->setBillingCycles($value);
        return $this;
    }

    /**
     * Sets payment preferences field.
     *
     * @param PaymentPreferences|null $value
     */
    public function paymentPreferences(?PaymentPreferences $value): self
    {
        $this->instance->setPaymentPreferences($value);
        return $this;
    }

    /**
     * Sets merchant preferences field.
     *
     * @param MerchantPreferences|null $value
     */
    public function merchantPreferences(?MerchantPreferences $value): self
    {
        $this->instance->setMerchantPreferences($value);
        return $this;
    }

    /**
     * Sets taxes field.
     *
     * @param Taxes|null $value
     */
    public function taxes(?Taxes $value): self
    {
        $this->instance->setTaxes($value);
        return $this;
    }

    /**
     * Sets quantity supported field.
     *
     * @param bool|null $value
     */
    public function quantitySupported(?bool $value): self
    {
        $this->instance->setQuantitySupported($value);
        return $this;
    }

    /**
     * Sets create time field.
     *
     * @param string|null $value
     */
    public function createTime(?string $value): self
    {
        $this->instance->setCreateTime($value);
        return $this;
    }

    /**
     * Sets update time field.
     *
     * @param string|null $value
     */
    public function updateTime(?string $value): self
    {
        $this->instance->setUpdateTime($value);
        return $this;
    }

    /**
     * Sets links field.
     *
     * @param LinkDescription[]|null $value
     */
    public function links(?array $value): self
    {
        $this->instance->setLinks($value);
        return $this;
    }

    /**
     * Initializes a new Billing Plan object.
     */
    public function build(): BillingPlan
    {
        return CoreHelper::clone($this->instance);
    }
}
