<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\CardCustomerInformation;
use PaypalServerSdkLib\Models\CardVaultResponse;
use PaypalServerSdkLib\Models\LinkDescription;

/**
 * Builder for model CardVaultResponse
 *
 * @see CardVaultResponse
 */
class CardVaultResponseBuilder
{
    /**
     * @var CardVaultResponse
     */
    private $instance;

    private function __construct(CardVaultResponse $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Card Vault Response Builder object.
     */
    public static function init(): self
    {
        return new self(new CardVaultResponse());
    }

    /**
     * Sets id field.
     *
     * @param string|null $value
     */
    public function id(?string $value): self
    {
        $this->instance->setId($value);
        return $this;
    }

    /**
     * Sets status field.
     *
     * @param string|null $value
     */
    public function status(?string $value): self
    {
        $this->instance->setStatus($value);
        return $this;
    }

    /**
     * Sets links field.
     *
     * @param LinkDescription[]|null $value
     */
    public function links(?array $value): self
    {
        $this->instance->setLinks($value);
        return $this;
    }

    /**
     * Sets customer field.
     *
     * @param CardCustomerInformation|null $value
     */
    public function customer(?CardCustomerInformation $value): self
    {
        $this->instance->setCustomer($value);
        return $this;
    }

    /**
     * Initializes a new Card Vault Response object.
     */
    public function build(): CardVaultResponse
    {
        return CoreHelper::clone($this->instance);
    }
}
