<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\CustomerVaultPaymentTokensResponse;
use PaypalServerSdkLib\Models\LinkDescription;
use PaypalServerSdkLib\Models\PaymentTokenResponse;
use PaypalServerSdkLib\Models\VaultResponseCustomer;

/**
 * Builder for model CustomerVaultPaymentTokensResponse
 *
 * @see CustomerVaultPaymentTokensResponse
 */
class CustomerVaultPaymentTokensResponseBuilder
{
    /**
     * @var CustomerVaultPaymentTokensResponse
     */
    private $instance;

    private function __construct(CustomerVaultPaymentTokensResponse $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Customer Vault Payment Tokens Response Builder object.
     */
    public static function init(): self
    {
        return new self(new CustomerVaultPaymentTokensResponse());
    }

    /**
     * Sets total items field.
     *
     * @param int|null $value
     */
    public function totalItems(?int $value): self
    {
        $this->instance->setTotalItems($value);
        return $this;
    }

    /**
     * Sets total pages field.
     *
     * @param int|null $value
     */
    public function totalPages(?int $value): self
    {
        $this->instance->setTotalPages($value);
        return $this;
    }

    /**
     * Sets customer field.
     *
     * @param VaultResponseCustomer|null $value
     */
    public function customer(?VaultResponseCustomer $value): self
    {
        $this->instance->setCustomer($value);
        return $this;
    }

    /**
     * Sets payment tokens field.
     *
     * @param PaymentTokenResponse[]|null $value
     */
    public function paymentTokens(?array $value): self
    {
        $this->instance->setPaymentTokens($value);
        return $this;
    }

    /**
     * Sets links field.
     *
     * @param LinkDescription[]|null $value
     */
    public function links(?array $value): self
    {
        $this->instance->setLinks($value);
        return $this;
    }

    /**
     * Initializes a new Customer Vault Payment Tokens Response object.
     */
    public function build(): CustomerVaultPaymentTokensResponse
    {
        return CoreHelper::clone($this->instance);
    }
}
