<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\FailedPaymentDetails;
use PaypalServerSdkLib\Models\Money;

/**
 * Builder for model FailedPaymentDetails
 *
 * @see FailedPaymentDetails
 */
class FailedPaymentDetailsBuilder
{
    /**
     * @var FailedPaymentDetails
     */
    private $instance;

    private function __construct(FailedPaymentDetails $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Failed Payment Details Builder object.
     *
     * @param Money $amount
     * @param string $time
     */
    public static function init(Money $amount, string $time): self
    {
        return new self(new FailedPaymentDetails($amount, $time));
    }

    /**
     * Sets reason code field.
     *
     * @param string|null $value
     */
    public function reasonCode(?string $value): self
    {
        $this->instance->setReasonCode($value);
        return $this;
    }

    /**
     * Sets next payment retry time field.
     *
     * @param string|null $value
     */
    public function nextPaymentRetryTime(?string $value): self
    {
        $this->instance->setNextPaymentRetryTime($value);
        return $this;
    }

    /**
     * Initializes a new Failed Payment Details object.
     */
    public function build(): FailedPaymentDetails
    {
        return CoreHelper::clone($this->instance);
    }
}
